/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.streaming;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.streaming.domain.Cluster;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ClustersClient
extends AbstractApiClient {
    public ClustersClient(String token) {
        this(token, AstraEnvironment.PROD);
    }

    public ClustersClient(String token, AstraEnvironment env) {
        super(token, env);
    }

    @Override
    public String getServiceName() {
        return "streaming.clusters";
    }

    public Stream<Cluster> findAll() {
        return JsonUtils.unmarshallType(this.GET(this.getApiDevopsEndpointClusters(), this.getOperationName("find")).getBody(), new TypeReference<List<Cluster>>(){}).stream();
    }

    public Optional<Cluster> find(String clusterName) {
        return this.findAll().filter(c -> c.getClusterName().equalsIgnoreCase(clusterName)).findFirst();
    }

    public boolean exist(String clusterName) {
        return this.find(clusterName).isPresent();
    }

    public String getApiDevopsEndpointClusters() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/streaming/clusters";
    }
}

