/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.utils.observability;

import com.dtsx.astra.sdk.utils.ApiResponse;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class ApiExecutionInfos
implements Serializable {
    private final Object request;
    private final String operationName;
    private final Map<String, List<String>> requestHttpHeaders;
    private final Method requestHttpMethod;
    private final String requestUrl;
    private final ApiResponse<?> response;
    private final String responseBody;
    private final int responseHttpCode;
    private final Map<String, String> responseHttpHeaders;
    private final long executionTime;
    private final Instant executionDate;

    private ApiExecutionInfos(ApiExecutionInfoBuilder builder) {
        this.operationName = builder.operationName;
        this.requestHttpMethod = builder.requestHttpMethod;
        this.request = builder.payload;
        this.requestHttpHeaders = builder.requestHttpHeaders;
        this.response = builder.response;
        this.responseHttpHeaders = builder.responseHttpHeaders;
        this.responseBody = builder.responseBody;
        this.responseHttpCode = builder.responseHttpCode;
        this.executionTime = builder.executionTime;
        this.executionDate = builder.executionDate;
        this.requestUrl = builder.requestUrl;
    }

    public static ApiExecutionInfoBuilder builder() {
        return new ApiExecutionInfoBuilder();
    }

    @Generated
    public Object getRequest() {
        return this.request;
    }

    @Generated
    public String getOperationName() {
        return this.operationName;
    }

    @Generated
    public Map<String, List<String>> getRequestHttpHeaders() {
        return this.requestHttpHeaders;
    }

    @Generated
    public Method getRequestHttpMethod() {
        return this.requestHttpMethod;
    }

    @Generated
    public String getRequestUrl() {
        return this.requestUrl;
    }

    @Generated
    public ApiResponse<?> getResponse() {
        return this.response;
    }

    @Generated
    public String getResponseBody() {
        return this.responseBody;
    }

    @Generated
    public int getResponseHttpCode() {
        return this.responseHttpCode;
    }

    @Generated
    public Map<String, String> getResponseHttpHeaders() {
        return this.responseHttpHeaders;
    }

    @Generated
    public long getExecutionTime() {
        return this.executionTime;
    }

    @Generated
    public Instant getExecutionDate() {
        return this.executionDate;
    }

    public static class ApiExecutionInfoBuilder {
        private String operationName;
        private Object payload;
        private Method requestHttpMethod;
        private ApiResponse<?> response;
        private long executionTime;
        private int responseHttpCode;
        private String responseBody;
        private Map<String, List<String>> requestHttpHeaders;
        private Map<String, String> responseHttpHeaders;
        private final Instant executionDate = Instant.now();
        private String requestUrl;

        public ApiExecutionInfoBuilder withRequestPayload(Object payload) {
            this.payload = payload;
            return this;
        }

        public ApiExecutionInfoBuilder withOperationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public ApiExecutionInfoBuilder withHttpRequest(HttpUriRequestBase req) {
            this.requestHttpMethod = Method.valueOf((String)req.getMethod());
            this.requestHttpHeaders = Arrays.stream(req.getHeaders()).collect(Collectors.toMap(NameValuePair::getName, h -> Collections.singletonList(h.getValue())));
            try {
                this.requestUrl = req.getUri().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (req.getEntity() != null) {
                try {
                    this.payload = EntityUtils.toString((HttpEntity)req.getEntity());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this;
        }

        public void withHttpResponse(ApiResponseHttp httpResponse) {
            Assert.notNull(httpResponse, "httpResponse");
            this.executionTime = System.currentTimeMillis() - 1000L * this.executionDate.getEpochSecond();
            this.responseHttpCode = httpResponse.getCode();
            this.responseHttpHeaders = httpResponse.getHeaders();
            this.responseBody = httpResponse.getBody();
        }

        public ApiExecutionInfos build() {
            return new ApiExecutionInfos(this);
        }
    }
}

