/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ConsumerStats;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;

public interface Consumer
extends Closeable {
    public String getTopic();

    public String getSubscription();

    public void unsubscribe() throws PulsarClientException;

    public CompletableFuture<Void> unsubscribeAsync();

    public Message<byte[]> receive() throws PulsarClientException;

    public CompletableFuture<Message<byte[]>> receiveAsync();

    public Message<byte[]> receive(int var1, TimeUnit var2) throws PulsarClientException;

    public void acknowledge(Message<?> var1) throws PulsarClientException;

    public void acknowledge(MessageId var1) throws PulsarClientException;

    public void acknowledgeCumulative(Message<?> var1) throws PulsarClientException;

    public void acknowledgeCumulative(MessageId var1) throws PulsarClientException;

    public CompletableFuture<Void> acknowledgeAsync(Message<?> var1);

    public CompletableFuture<Void> acknowledgeAsync(MessageId var1);

    public CompletableFuture<Void> acknowledgeCumulativeAsync(Message<?> var1);

    public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId var1);

    public ConsumerStats getStats();

    @Override
    public void close() throws PulsarClientException;

    public CompletableFuture<Void> closeAsync();

    public boolean hasReachedEndOfTopic();

    public void redeliverUnacknowledgedMessages();

    public void seek(MessageId var1) throws PulsarClientException;

    public void seek(long var1) throws PulsarClientException;

    public CompletableFuture<Void> seekAsync(MessageId var1);

    public CompletableFuture<Void> seekAsync(long var1);

    public boolean isConnected();

    public String getConsumerName();

    public void pause();

    public void resume();
}

