/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.ConsumerEventListener;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.v1.ConsumerV1Impl;
import org.apache.pulsar.shade.client.api.v2.Consumer;

@Deprecated
public class ConsumerConfiguration
implements Serializable {
    static long minAckTimeoutMillis = 1000L;
    private static final long serialVersionUID = 1L;
    private final ConsumerConfigurationData<byte[]> conf = new ConsumerConfigurationData();
    private MessageListener<byte[]> messageListener;

    public ConsumerConfiguration() {
        this.conf.setAcknowledgementsGroupTimeMicros(0L);
    }

    public long getAckTimeoutMillis() {
        return this.conf.getAckTimeoutMillis();
    }

    public ConsumerConfiguration setAckTimeout(long ackTimeout, TimeUnit timeUnit) {
        long ackTimeoutMillis = timeUnit.toMillis(ackTimeout);
        Preconditions.checkArgument((ackTimeoutMillis >= minAckTimeoutMillis ? 1 : 0) != 0, (Object)("Ack timeout should be should be greater than " + minAckTimeoutMillis + " ms"));
        this.conf.setAckTimeoutMillis(timeUnit.toMillis(ackTimeout));
        return this;
    }

    public SubscriptionType getSubscriptionType() {
        return this.conf.getSubscriptionType();
    }

    public ConsumerConfiguration setSubscriptionType(SubscriptionType subscriptionType) {
        Objects.requireNonNull(subscriptionType);
        this.conf.setSubscriptionType(subscriptionType);
        return this;
    }

    public MessageListener<byte[]> getMessageListener() {
        return this.messageListener;
    }

    public ConsumerConfiguration setMessageListener(final MessageListener<byte[]> messageListener) {
        Objects.requireNonNull(messageListener);
        this.messageListener = messageListener;
        this.conf.setMessageListener((org.apache.pulsar.shade.client.api.v2.MessageListener)new org.apache.pulsar.shade.client.api.v2.MessageListener<byte[]>(){

            public void received(Consumer<byte[]> consumer, Message<byte[]> msg) {
                messageListener.received(new ConsumerV1Impl(consumer), msg);
            }

            public void reachedEndOfTopic(Consumer<byte[]> consumer) {
                messageListener.reachedEndOfTopic(new ConsumerV1Impl(consumer));
            }
        });
        return this;
    }

    public ConsumerEventListener getConsumerEventListener() {
        return this.conf.getConsumerEventListener();
    }

    public ConsumerConfiguration setConsumerEventListener(ConsumerEventListener listener) {
        Objects.requireNonNull(listener);
        this.conf.setConsumerEventListener(listener);
        return this;
    }

    public int getReceiverQueueSize() {
        return this.conf.getReceiverQueueSize();
    }

    public int getMaxTotalReceiverQueueSizeAcrossPartitions() {
        return this.conf.getMaxTotalReceiverQueueSizeAcrossPartitions();
    }

    public void setMaxTotalReceiverQueueSizeAcrossPartitions(int maxTotalReceiverQueueSizeAcrossPartitions) {
        Preconditions.checkArgument((maxTotalReceiverQueueSizeAcrossPartitions >= this.conf.getReceiverQueueSize() ? 1 : 0) != 0);
        this.conf.setMaxTotalReceiverQueueSizeAcrossPartitions(maxTotalReceiverQueueSizeAcrossPartitions);
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.conf.getCryptoKeyReader();
    }

    public ConsumerConfiguration setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        Objects.requireNonNull(cryptoKeyReader);
        this.conf.setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction action) {
        this.conf.setCryptoFailureAction(action);
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.conf.getCryptoFailureAction();
    }

    public ConsumerConfiguration setReceiverQueueSize(int receiverQueueSize) {
        Preconditions.checkArgument((receiverQueueSize >= 0 ? 1 : 0) != 0, (Object)"Receiver queue size cannot be negative");
        this.conf.setReceiverQueueSize(receiverQueueSize);
        return this;
    }

    public String getConsumerName() {
        return this.conf.getConsumerName();
    }

    public ConsumerConfiguration setConsumerName(String consumerName) {
        Preconditions.checkArgument((consumerName != null && !consumerName.equals("") ? 1 : 0) != 0);
        this.conf.setConsumerName(consumerName);
        return this;
    }

    public int getPriorityLevel() {
        return this.conf.getPriorityLevel();
    }

    public void setPriorityLevel(int priorityLevel) {
        this.conf.setPriorityLevel(priorityLevel);
    }

    public boolean getReadCompacted() {
        return this.conf.isReadCompacted();
    }

    public ConsumerConfiguration setReadCompacted(boolean readCompacted) {
        this.conf.setReadCompacted(readCompacted);
        return this;
    }

    public ConsumerConfiguration setProperty(String key, String value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        this.conf.getProperties().put(key, value);
        return this;
    }

    public ConsumerConfiguration setProperties(Map<String, String> properties) {
        this.conf.getProperties().putAll(properties);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.conf.getProperties();
    }

    public ConsumerConfigurationData<byte[]> getConfigurationData() {
        return this.conf;
    }

    public ConsumerConfiguration setSubscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
        this.conf.setSubscriptionInitialPosition(subscriptionInitialPosition);
        return this;
    }

    public SubscriptionInitialPosition getSubscriptionInitialPosition() {
        return this.conf.getSubscriptionInitialPosition();
    }

    public RedeliveryBackoff getNegativeAckRedeliveryBackoff() {
        return this.conf.getNegativeAckRedeliveryBackoff();
    }

    public ConsumerConfiguration setNegativeAckRedeliveryBackoff(RedeliveryBackoff negativeAckRedeliveryBackoff) {
        this.conf.setNegativeAckRedeliveryBackoff(negativeAckRedeliveryBackoff);
        return this;
    }

    public RedeliveryBackoff getAckTimeoutRedeliveryBackoff() {
        return this.conf.getAckTimeoutRedeliveryBackoff();
    }

    public ConsumerConfiguration setAckTimeoutRedeliveryBackoff(RedeliveryBackoff ackTimeoutRedeliveryBackoff) {
        this.conf.setAckTimeoutRedeliveryBackoff(ackTimeoutRedeliveryBackoff);
        return this;
    }
}

