/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.docs;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.apache.pulsar.io.core.annotations.Connector;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="connector-doc-gen")
public class ConnectorDocGenerator
implements Callable<Integer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorDocGenerator.class);
    private static final String INDENT = "  ";
    private final Reflections reflections = ConnectorDocGenerator.newReflections();
    @CommandLine.Option(names={"-o", "--output-dir"}, description={"The output dir to dump connector docs"}, required=true)
    String outputDir = null;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message"})
    boolean help = false;

    private static Reflections newReflections() throws Exception {
        String[] classpathList = System.getProperty("java.class.path").split(":");
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (String file : classpathList) {
            urlList.add(new File(file).toURI().toURL());
        }
        return new Reflections((Configuration)new ConfigurationBuilder().setUrls(urlList));
    }

    private void generateConnectorYamlFile(Class<?> configClass, PrintWriter writer) {
        Field[] fields;
        log.info("Processing connector config class : {}", configClass);
        writer.println("configs:");
        for (Field field : fields = configClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            FieldDoc fieldDoc = field.getDeclaredAnnotation(FieldDoc.class);
            if (null == fieldDoc) {
                String message = "Missing FieldDoc for field '%s' in class '%s'.".formatted(field.getName(), configClass.getCanonicalName());
                throw new RuntimeException(message);
            }
            writer.println("  # " + fieldDoc.help());
            String fieldPrefix = "";
            if (!fieldDoc.required()) {
                fieldPrefix = "# ";
            }
            if (Strings.isNullOrEmpty((String)fieldDoc.defaultValue())) {
                writer.println(INDENT + fieldPrefix + field.getName() + ":");
            } else {
                writer.println(INDENT + fieldPrefix + field.getName() + ": " + fieldDoc.defaultValue());
            }
            writer.println();
        }
        writer.flush();
    }

    private void generateConnectorYamlFile(Class<?> connectorClass, Connector connectorDef, PrintWriter writer) {
        log.info("Processing connector definition : {}", (Object)connectorDef);
        writer.println("# " + String.valueOf(connectorDef.type()) + " connector : " + connectorClass.getName());
        writer.println();
        writer.println("# " + connectorDef.help());
        writer.println();
        this.generateConnectorYamlFile(connectorDef.configClass(), writer);
    }

    private void generatorConnectorYamlFiles(String outputDir) throws IOException {
        Set connectorClasses = this.reflections.getTypesAnnotatedWith(Connector.class);
        log.info("Retrieve all `Connector` annotated classes : {}", (Object)connectorClasses);
        for (Class connectorClass : connectorClasses) {
            Connector connectorDef = connectorClass.getDeclaredAnnotation(Connector.class);
            String name = connectorDef.name().toLowerCase();
            String type = connectorDef.type().name().toLowerCase();
            String filename = "pulsar-io-%s-%s.yml".formatted(name, type);
            Path outputPath = Path.of(outputDir, filename);
            try (FileOutputStream fos = new FileOutputStream(outputPath.toFile());){
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));
                this.generateConnectorYamlFile(connectorClass, connectorDef, pw);
                pw.flush();
            }
        }
    }

    @Override
    public Integer call() throws Exception {
        ConnectorDocGenerator docGen = new ConnectorDocGenerator();
        docGen.generatorConnectorYamlFiles(this.outputDir);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        CommandLine commander = new CommandLine((Object)new ConnectorDocGenerator());
        Runtime.getRuntime().exit(commander.execute(args));
    }
}

