/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion.ionvalue;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.system.IonSystemBuilder;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.ion.EnumAsIonSymbolModule;
import com.fasterxml.jackson.dataformat.ion.IonFactory;
import com.fasterxml.jackson.dataformat.ion.IonObjectMapper;
import com.fasterxml.jackson.dataformat.ion.ionvalue.IonValueModule;
import java.io.IOException;

public class IonValueMapper
extends IonObjectMapper {
    private static final long serialVersionUID = 1L;

    public IonValueMapper(IonSystem ionSystem) {
        this(ionSystem, null);
    }

    protected IonValueMapper(IonValueMapper src) {
        super(src);
    }

    protected IonValueMapper(IonFactory f, PropertyNamingStrategy strategy) {
        super(f);
        this.registerModule((Module)new IonValueModule());
        this.registerModule((Module)new EnumAsIonSymbolModule());
        this.setPropertyNamingStrategy(strategy);
    }

    public IonValueMapper(IonSystem ionSystem, PropertyNamingStrategy strategy) {
        this(new IonFactory(null, ionSystem), strategy);
    }

    public static IonObjectMapper.Builder builder() {
        return IonValueMapper.builder(IonSystemBuilder.standard().build());
    }

    public static IonObjectMapper.Builder builder(IonSystem ionSystem) {
        return IonValueMapper.builder(ionSystem, null);
    }

    public static IonObjectMapper.Builder builder(IonSystem ionSystem, PropertyNamingStrategy strategy) {
        return new IonObjectMapper.Builder(new IonValueMapper(ionSystem, strategy));
    }

    public static IonObjectMapper.Builder builderForBinaryWriters() {
        return IonValueMapper.builderForBinaryWriters(IonSystemBuilder.standard().build());
    }

    public static IonObjectMapper.Builder builderForBinaryWriters(IonSystem ionSystem) {
        return IonValueMapper.builder(IonFactory.builderForBinaryWriters().ionSystem(ionSystem).build());
    }

    public static IonObjectMapper.Builder builderForTextualWriters() {
        return IonValueMapper.builderForTextualWriters(IonSystemBuilder.standard().build());
    }

    public static IonObjectMapper.Builder builderForTextualWriters(IonSystem ionSystem) {
        return IonValueMapper.builder(IonFactory.builderForTextualWriters().ionSystem(ionSystem).build());
    }

    public static IonObjectMapper.Builder builder(IonFactory streamFactory) {
        return IonValueMapper.builder(streamFactory, null);
    }

    public static IonObjectMapper.Builder builder(IonFactory streamFactory, PropertyNamingStrategy strategy) {
        return new IonObjectMapper.Builder(new IonValueMapper(streamFactory, strategy));
    }

    @Override
    public ObjectMapper copy() {
        this._checkInvalidCopy(IonValueMapper.class);
        return new IonValueMapper(this);
    }

    public <T> T parse(IonValue value, Class<T> clazz) throws IOException {
        if (value == null) {
            return null;
        }
        return this.readValue(value, clazz);
    }

    public <T> IonValue serialize(T o) throws IOException {
        if (o == null) {
            return null;
        }
        return this.writeValueAsIonValue(o);
    }
}

