/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.Client;
import com.microsoft.azure.kusto.data.ClientImpl;
import com.microsoft.azure.kusto.data.HttpClientProperties;
import com.microsoft.azure.kusto.data.StreamingClient;
import com.microsoft.azure.kusto.data.auth.ConnectionStringBuilder;
import java.net.URISyntaxException;
import org.apache.http.impl.client.CloseableHttpClient;

public class ClientFactory {
    private ClientFactory() {
    }

    public static Client createClient(ConnectionStringBuilder csb) throws URISyntaxException {
        return ClientFactory.createClient(csb, (HttpClientProperties)null);
    }

    public static Client createClient(ConnectionStringBuilder csb, HttpClientProperties properties) throws URISyntaxException {
        return new ClientImpl(csb, properties);
    }

    public static Client createClient(ConnectionStringBuilder csb, CloseableHttpClient client) throws URISyntaxException {
        return client == null ? ClientFactory.createClient(csb, (HttpClientProperties)null) : new ClientImpl(csb, client, true);
    }

    public static StreamingClient createStreamingClient(ConnectionStringBuilder csb) throws URISyntaxException {
        return ClientFactory.createStreamingClient(csb, (HttpClientProperties)null);
    }

    public static StreamingClient createStreamingClient(ConnectionStringBuilder csb, HttpClientProperties properties) throws URISyntaxException {
        return new ClientImpl(csb, properties);
    }

    public static StreamingClient createStreamingClient(ConnectionStringBuilder csb, CloseableHttpClient httpClient) throws URISyntaxException {
        return new ClientImpl(csb, httpClient, true);
    }
}

