/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth.endpoints;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.data.StringUtils;
import com.microsoft.azure.kusto.data.auth.endpoints.MatchResult;
import com.microsoft.azure.kusto.data.auth.endpoints.MatchRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FastSuffixMatcher {
    private final int suffixLength;
    private final Map<String, List<MatchRule>> rules;

    public static FastSuffixMatcher create(List<MatchRule> rules) {
        Ensure.argIsNotNull(rules, "rules");
        int minRuleLength = rules.stream().min(Comparator.comparing(MatchRule::getSuffixLength)).map(MatchRule::getSuffixLength).orElse(0);
        Ensure.isTrue(minRuleLength > 0 && minRuleLength != Integer.MAX_VALUE, "Cannot have a match rule whose length is zero");
        TreeMap<String, List<MatchRule>> processedRules = new TreeMap<String, List<MatchRule>>(String.CASE_INSENSITIVE_ORDER);
        for (MatchRule rule : rules) {
            String suffix = StringUtils.getStringTail(rule.suffix, minRuleLength);
            List list = processedRules.computeIfAbsent(suffix, k -> new ArrayList());
            list.add(rule.clone());
        }
        return new FastSuffixMatcher(minRuleLength, processedRules);
    }

    public static FastSuffixMatcher create(FastSuffixMatcher existing, List<MatchRule> rules) {
        if (existing == null || existing.rules.size() == 0) {
            return FastSuffixMatcher.create(rules);
        }
        if (rules == null || rules.isEmpty()) {
            return existing;
        }
        List<MatchRule> list = Stream.concat(rules.stream(), existing.rules.values().stream().flatMap(Collection::stream)).collect(Collectors.toList());
        return FastSuffixMatcher.create(list);
    }

    public Boolean isMatch(String candidate) {
        return this.match((String)candidate).isMatch;
    }

    public MatchResult match(String candidate) {
        Ensure.argIsNotNull(candidate, "candidate");
        if (candidate.length() < this.suffixLength) {
            return new MatchResult(false, null);
        }
        List<MatchRule> matchRules = this.rules.get(StringUtils.getStringTail(candidate, this.suffixLength));
        if (matchRules != null) {
            for (MatchRule rule : matchRules) {
                if (!org.apache.commons.lang3.StringUtils.endsWithIgnoreCase((CharSequence)candidate, (CharSequence)rule.suffix) || candidate.length() != rule.suffix.length() && rule.exact.booleanValue()) continue;
                return new MatchResult(true, rule);
            }
        }
        return new MatchResult(false, null);
    }

    private FastSuffixMatcher(int suffixLength, Map<String, List<MatchRule>> rules) {
        this.suffixLength = suffixLength;
        this.rules = rules;
    }
}

