/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.exceptions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.exceptions.OneApiError;
import com.microsoft.azure.kusto.data.exceptions.WebException;
import java.lang.invoke.MethodHandles;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWebException
extends WebException {
    private OneApiError apiError = null;
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ObjectMapper objectMapper = Utils.getObjectMapper();

    public DataWebException(String message, HttpResponse httpResponse, Throwable cause) {
        super(message, httpResponse, cause);
    }

    public DataWebException(String message, HttpResponse httpResponse) {
        this(message, httpResponse, null);
    }

    public DataWebException(String message) {
        this(message, null, null);
    }

    public OneApiError getApiError() {
        if (this.apiError == null) {
            try {
                this.apiError = OneApiError.fromJsonObject(this.objectMapper.readTree(this.getMessage()).get("error"));
            }
            catch (JsonProcessingException e) {
                this.log.error("failed to parse error from message {} {} ", (Object)e.getMessage(), (Object)e);
            }
        }
        return this.apiError;
    }
}

