/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.instrumentation.TraceableAttributes;
import com.microsoft.azure.kusto.ingest.ColumnMapping;
import com.microsoft.azure.kusto.ingest.IngestionMapping;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionClientException;
import com.microsoft.azure.kusto.ingest.result.ValidationPolicy;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.TextStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestionProperties
implements TraceableAttributes {
    private final String databaseName;
    private final String tableName;
    private boolean flushImmediately;
    private boolean ignoreFirstRecord;
    private IngestionReportLevel reportLevel;
    private IngestionReportMethod reportMethod;
    private List<String> dropByTags;
    private List<String> ingestByTags;
    private List<String> additionalTags;
    private List<String> ingestIfNotExists;
    private IngestionMapping ingestionMapping;
    private ValidationPolicy validationPolicy;
    private Map<String, String> additionalProperties;
    private DataFormat dataFormat;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public IngestionProperties(String databaseName, String tableName) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.reportLevel = IngestionReportLevel.FAILURES_ONLY;
        this.reportMethod = IngestionReportMethod.QUEUE;
        this.flushImmediately = false;
        this.ignoreFirstRecord = false;
        this.additionalProperties = new HashMap<String, String>();
        this.dropByTags = new ArrayList<String>();
        this.ingestByTags = new ArrayList<String>();
        this.ingestIfNotExists = new ArrayList<String>();
        this.additionalTags = new ArrayList<String>();
        this.ingestionMapping = new IngestionMapping();
        this.dataFormat = DataFormat.CSV;
    }

    public IngestionProperties(IngestionProperties other) {
        this.databaseName = other.databaseName;
        this.tableName = other.tableName;
        this.reportLevel = other.reportLevel;
        this.reportMethod = other.reportMethod;
        this.flushImmediately = other.flushImmediately;
        this.ignoreFirstRecord = other.ignoreFirstRecord;
        this.dataFormat = other.getDataFormat();
        this.additionalProperties = new HashMap<String, String>(other.additionalProperties);
        this.dropByTags = new ArrayList<String>(other.dropByTags);
        this.ingestByTags = new ArrayList<String>(other.ingestByTags);
        this.ingestIfNotExists = new ArrayList<String>(other.ingestIfNotExists);
        this.additionalTags = new ArrayList<String>(other.additionalTags);
        if (other.ingestionMapping != null) {
            this.ingestionMapping = new IngestionMapping(other.ingestionMapping);
        }
        if (other.validationPolicy != null) {
            this.validationPolicy = new ValidationPolicy(other.validationPolicy);
        }
    }

    public ValidationPolicy getValidationPolicy() {
        return this.validationPolicy;
    }

    public void setValidationPolicy(ValidationPolicy validationPolicy) {
        this.validationPolicy = validationPolicy;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean getFlushImmediately() {
        return this.flushImmediately;
    }

    public void setFlushImmediately(boolean flushImmediately) {
        this.flushImmediately = flushImmediately;
    }

    public boolean isIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public void setIgnoreFirstRecord(boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public IngestionReportLevel getReportLevel() {
        return this.reportLevel;
    }

    public void setReportLevel(IngestionReportLevel reportLevel) {
        this.reportLevel = reportLevel;
    }

    public IngestionReportMethod getReportMethod() {
        return this.reportMethod;
    }

    public void setReportMethod(IngestionReportMethod reportMethod) {
        this.reportMethod = reportMethod;
    }

    public List<String> getDropByTags() {
        return this.dropByTags;
    }

    public void setDropByTags(List<String> dropByTags) {
        this.dropByTags = dropByTags;
    }

    public List<String> getIngestByTags() {
        return this.ingestByTags;
    }

    public void setIngestByTags(List<String> ingestByTags) {
        this.ingestByTags = ingestByTags;
    }

    public List<String> getAdditionalTags() {
        return this.additionalTags;
    }

    public void setAdditionalTags(List<String> additionalTags) {
        this.additionalTags = additionalTags;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public List<String> getIngestIfNotExists() {
        return this.ingestIfNotExists;
    }

    public void setIngestIfNotExists(List<String> ingestIfNotExists) {
        this.ingestIfNotExists = ingestIfNotExists;
    }

    Map<String, String> getIngestionProperties() throws IOException {
        ObjectMapper objectMapper;
        HashMap<String, String> fullAdditionalProperties = new HashMap<String, String>();
        if (!(this.dropByTags.isEmpty() && this.ingestByTags.isEmpty() && this.additionalTags.isEmpty())) {
            ArrayList<String> tags = new ArrayList<String>();
            if (!this.additionalTags.isEmpty()) {
                tags.addAll(this.additionalTags);
            }
            if (!this.ingestByTags.isEmpty()) {
                for (String t : this.ingestByTags) {
                    tags.add(String.format("%s%s", "ingest-by:", t));
                }
            }
            if (!this.dropByTags.isEmpty()) {
                for (String t : this.dropByTags) {
                    tags.add(String.format("%s%s", "drop-by:", t));
                }
            }
            objectMapper = Utils.getObjectMapper();
            String tagsAsJson = objectMapper.writeValueAsString(tags);
            fullAdditionalProperties.put("tags", tagsAsJson);
        }
        if (!this.ingestIfNotExists.isEmpty()) {
            ObjectMapper objectMapper2 = Utils.getObjectMapper();
            String ingestIfNotExistsJson = objectMapper2.writeValueAsString(this.ingestIfNotExists);
            fullAdditionalProperties.put("ingestIfNotExists", ingestIfNotExistsJson);
        }
        fullAdditionalProperties.putAll(this.additionalProperties);
        fullAdditionalProperties.put("format", this.dataFormat.getKustoValue());
        fullAdditionalProperties.put("ignoreFirstRecord", Boolean.toString(this.ignoreFirstRecord));
        String mappingReference = this.ingestionMapping.getIngestionMappingReference();
        if (StringUtils.isNotBlank((CharSequence)mappingReference)) {
            fullAdditionalProperties.put("ingestionMappingReference", mappingReference);
            fullAdditionalProperties.put("ingestionMappingType", this.ingestionMapping.getIngestionMappingKind().getKustoValue());
        } else if (this.ingestionMapping.getColumnMappings() != null) {
            objectMapper = Utils.getObjectMapper();
            objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
            objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            String mapping = objectMapper.writeValueAsString((Object)this.ingestionMapping.getColumnMappings());
            fullAdditionalProperties.put("ingestionMapping", mapping);
            fullAdditionalProperties.put("ingestionMappingType", this.ingestionMapping.getIngestionMappingKind().getKustoValue());
        }
        return fullAdditionalProperties;
    }

    public void setDataFormat(@NotNull DataFormat dataFormat) {
        Ensure.argIsNotNull((Object)((Object)dataFormat), (String)"dataFormat");
        this.dataFormat = dataFormat;
    }

    public void setDataFormat(@NotNull String dataFormatName) {
        try {
            this.dataFormat = DataFormat.valueOf(dataFormatName.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            log.warn("IngestionProperties.setDataFormat(): Invalid dataFormatName of {}. Per the API's specification, DataFormat property value wasn't set.", (Object)dataFormatName);
        }
    }

    @NotNull
    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setIngestionMapping(String mappingReference, IngestionMapping.IngestionMappingKind ingestionMappingKind) {
        this.ingestionMapping = new IngestionMapping(mappingReference, ingestionMappingKind);
    }

    public void setIngestionMapping(ColumnMapping[] columnMappings, IngestionMapping.IngestionMappingKind ingestionMappingKind) {
        this.ingestionMapping = new IngestionMapping(columnMappings, ingestionMappingKind);
    }

    public void setIngestionMapping(IngestionMapping ingestionMapping) {
        this.ingestionMapping = ingestionMapping;
    }

    public IngestionMapping getIngestionMapping() {
        return this.ingestionMapping;
    }

    public void setAuthorizationContextToken(String token) {
        this.additionalProperties.put("authorizationContext", token);
    }

    void validate() throws IngestionClientException {
        Ensure.stringIsNotBlank((String)this.databaseName, (String)"databaseName");
        Ensure.stringIsNotBlank((String)this.tableName, (String)"tableName");
        Ensure.argIsNotNull((Object)((Object)this.reportMethod), (String)"reportMethod");
        String mappingReference = this.ingestionMapping.getIngestionMappingReference();
        IngestionMapping.IngestionMappingKind ingestionMappingKind = this.ingestionMapping.getIngestionMappingKind();
        TextStringBuilder message = new TextStringBuilder();
        if (this.ingestionMapping.getColumnMappings() == null && StringUtils.isBlank((CharSequence)mappingReference)) {
            if (ingestionMappingKind != null) {
                message.appendln("IngestionMappingKind was defined ('%s'), so a mapping must be defined as well.", new Object[]{ingestionMappingKind});
            }
        } else {
            if (this.dataFormat.getIngestionMappingKind() != null && !this.dataFormat.getIngestionMappingKind().equals((Object)ingestionMappingKind)) {
                message.appendln("Wrong ingestion mapping for format '%s'; mapping kind should be '%s', but was '%s'.", new Object[]{this.dataFormat.getKustoValue(), this.dataFormat.getIngestionMappingKind().getKustoValue(), ingestionMappingKind != null ? ingestionMappingKind.getKustoValue() : "null"});
            }
            if (this.ingestionMapping.getColumnMappings() != null) {
                if (StringUtils.isNotBlank((CharSequence)mappingReference)) {
                    message.appendln("Both mapping reference '%s' and column mappings were defined.", new Object[]{mappingReference});
                }
                if (ingestionMappingKind != null) {
                    for (ColumnMapping column : this.ingestionMapping.getColumnMappings()) {
                        if (column.isValid(ingestionMappingKind)) continue;
                        message.appendln("Column mapping '%s' is invalid.", new Object[]{column.getColumnName()});
                    }
                }
            }
        }
        if (!message.isEmpty()) {
            String messageStr = message.build();
            log.error(messageStr);
            throw new IngestionClientException(messageStr);
        }
    }

    public void validateResultSetProperties() throws IngestionClientException {
        Ensure.isTrue((boolean)DataFormat.CSV.equals((Object)this.dataFormat), (String)String.format("ResultSet translates into csv format but '%s' was given", new Object[]{this.dataFormat}));
        this.validate();
    }

    public Map<String, String> getTracingAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("database", this.databaseName);
        attributes.put("table", this.tableName);
        return attributes;
    }

    public static enum IngestionReportMethod {
        QUEUE("Queue"),
        TABLE("Table"),
        QUEUE_AND_TABLE("QueueAndTable");

        private final String kustoValue;

        private IngestionReportMethod(String kustoValue) {
            this.kustoValue = kustoValue;
        }

        public String getKustoValue() {
            return this.kustoValue;
        }
    }

    public static enum IngestionReportLevel {
        FAILURES_ONLY("FailuresOnly"),
        NONE("None"),
        FAILURES_AND_SUCCESSES("FailuresAndSuccesses");

        private final String kustoValue;

        private IngestionReportLevel(String kustoValue) {
            this.kustoValue = kustoValue;
        }

        public String getKustoValue() {
            return this.kustoValue;
        }
    }

    public static enum DataFormat {
        CSV("csv", IngestionMapping.IngestionMappingKind.CSV, true),
        TSV("tsv", IngestionMapping.IngestionMappingKind.CSV, true),
        SCSV("scsv", IngestionMapping.IngestionMappingKind.CSV, true),
        SOHSV("sohsv", IngestionMapping.IngestionMappingKind.CSV, true),
        PSV("psv", IngestionMapping.IngestionMappingKind.CSV, true),
        TXT("txt", IngestionMapping.IngestionMappingKind.CSV, true),
        TSVE("tsve", IngestionMapping.IngestionMappingKind.CSV, true),
        JSON("json", IngestionMapping.IngestionMappingKind.JSON, true),
        SINGLEJSON("singlejson", IngestionMapping.IngestionMappingKind.JSON, true),
        MULTIJSON("multijson", IngestionMapping.IngestionMappingKind.JSON, true),
        AVRO("avro", IngestionMapping.IngestionMappingKind.AVRO, false),
        APACHEAVRO("apacheavro", IngestionMapping.IngestionMappingKind.APACHEAVRO, false),
        PARQUET("parquet", IngestionMapping.IngestionMappingKind.PARQUET, false),
        SSTREAM("sstream", IngestionMapping.IngestionMappingKind.SSTREAM, false),
        ORC("orc", IngestionMapping.IngestionMappingKind.ORC, false),
        RAW("raw", IngestionMapping.IngestionMappingKind.CSV, true),
        W3CLOGFILE("w3clogfile", IngestionMapping.IngestionMappingKind.W3CLOGFILE, true);

        private final String kustoValue;
        private final IngestionMapping.IngestionMappingKind ingestionMappingKind;
        private final boolean compressible;

        private DataFormat(String kustoValue, IngestionMapping.IngestionMappingKind ingestionMappingKind, boolean compressible) {
            this.kustoValue = kustoValue;
            this.ingestionMappingKind = ingestionMappingKind;
            this.compressible = compressible;
        }

        public String getKustoValue() {
            return this.kustoValue;
        }

        public IngestionMapping.IngestionMappingKind getIngestionMappingKind() {
            return this.ingestionMappingKind;
        }

        public boolean isCompressible() {
            return this.compressible;
        }
    }
}

