/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.utils;

import com.azure.core.http.HttpClient;
import com.azure.data.tables.TableClient;
import com.azure.data.tables.TableClientBuilder;
import com.microsoft.azure.kusto.data.UriUtils;
import java.net.URISyntaxException;
import reactor.util.annotation.Nullable;

public class TableWithSas {
    private final String uri;
    private final TableClient table;

    public TableWithSas(String url, @Nullable HttpClient httpClient) throws URISyntaxException {
        this.uri = url;
        this.table = TableWithSas.TableClientFromUrl(url, httpClient);
    }

    public String getUri() {
        return this.uri;
    }

    public TableClient getTable() {
        return this.table;
    }

    public static TableClient TableClientFromUrl(String url, @Nullable HttpClient httpClient) throws URISyntaxException {
        String[] parts = UriUtils.getSasAndEndpointFromResourceURL((String)url);
        int tableNameIndex = parts[0].lastIndexOf(47);
        String tableName = parts[0].substring(tableNameIndex + 1);
        return new TableClientBuilder().endpoint(parts[0].substring(0, tableNameIndex)).sasToken(parts[1]).tableName(tableName).httpClient(httpClient).buildClient();
    }
}

