/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.extensions.mhc4.impl;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLInitializationException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.ConfigUtils;

public class MavenHttpClient4FactoryImpl {
    protected static final String BIND_ADDRESS = "aether.connector.bind.address";
    protected static final String USE_SYSTEM_PROPERTIES = "aether.connector.http.useSystemProperties";
    protected static final String HTTP_RETRY_HANDLER_NAME = "aether.connector.http.retryHandler.name";
    protected static final String HTTP_RETRY_HANDLER_NAME_STANDARD = "standard";
    protected static final String HTTP_RETRY_HANDLER_NAME_DEFAULT = "default";
    protected static final String HTTP_RETRY_HANDLER_REQUEST_SENT_ENABLED = "aether.connector.http.retryHandler.requestSentEnabled";
    protected final RepositorySystem repositorySystem;

    public MavenHttpClient4FactoryImpl(RepositorySystem repositorySystem) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
    }

    public HttpClientBuilder createResolutionClient(RepositorySystemSession session, RemoteRepository repository) {
        Objects.requireNonNull(session, "session");
        Objects.requireNonNull(repository, "repository");
        List repositories = this.repositorySystem.newResolutionRepositories(session, Collections.singletonList(repository));
        if (repositories.size() != 1) {
            throw new IllegalArgumentException("No remote repository to build from: " + repositories);
        }
        RemoteRepository remoteRepository = (RemoteRepository)repositories.get(0);
        if (remoteRepository.isBlocked()) {
            throw new IllegalArgumentException("Remote repository is blocked: " + remoteRepository);
        }
        return this.createClient(session, remoteRepository);
    }

    public HttpClientBuilder createDeploymentClient(RepositorySystemSession session, RemoteRepository repository) {
        Objects.requireNonNull(session, "session");
        Objects.requireNonNull(repository, "repository");
        return this.createClient(session, this.repositorySystem.newDeploymentRepository(session, repository));
    }

    protected HttpClientBuilder createClient(RepositorySystemSession session, RemoteRepository repository) {
        HttpHost server;
        try {
            URI baseUri = new URI(repository.getUrl()).parseServerAuthority();
            if (baseUri.isOpaque()) {
                throw new URISyntaxException(repository.getUrl(), "URL must not be opaque");
            }
            server = URIUtils.extractHost((URI)baseUri);
            if (server == null) {
                throw new URISyntaxException(repository.getUrl(), "URL lacks host name");
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal RemoteRepository " + repository, e);
        }
        HttpHost proxy = MavenHttpClient4FactoryImpl.toHost(repository.getProxy());
        try (AuthenticationContext repoAuthContext = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repository);){
            HttpClientBuilder httpClientBuilder;
            block25: {
                AuthenticationContext proxyAuthContext = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repository);
                try {
                    boolean reuseConnections;
                    StandardHttpRequestRetryHandler retryHandler;
                    String httpsSecurityMode = ConfigUtils.getString((RepositorySystemSession)session, (String)HTTP_RETRY_HANDLER_NAME_DEFAULT, (String[])new String[]{"aether.connector.https.securityMode." + repository.getId(), "aether.connector.https.securityMode"});
                    int connectionMaxTtlSeconds = ConfigUtils.getInteger((RepositorySystemSession)session, (int)300, (String[])new String[]{"aether.connector.http.connectionMaxTtl." + repository.getId(), "aether.connector.http.connectionMaxTtl"});
                    int maxConnectionsPerRoute = ConfigUtils.getInteger((RepositorySystemSession)session, (int)50, (String[])new String[]{"aether.connector.http.maxConnectionsPerRoute." + repository.getId(), "aether.connector.http.maxConnectionsPerRoute"});
                    HttpClientConnectionManager connectionManager = MavenHttpClient4FactoryImpl.newConnectionManager(new ConnMgrConfig(session, repoAuthContext, httpsSecurityMode, connectionMaxTtlSeconds, maxConnectionsPerRoute));
                    String credentialEncoding = ConfigUtils.getString((RepositorySystemSession)session, (String)"ISO-8859-1", (String[])new String[]{"aether.connector.http.credentialEncoding." + repository.getId(), "aether.connector.http.credentialEncoding"});
                    int connectTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)10000, (String[])new String[]{"aether.connector.connectTimeout." + repository.getId(), "aether.connector.connectTimeout"});
                    int requestTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)1800000, (String[])new String[]{"aether.connector.requestTimeout." + repository.getId(), "aether.connector.requestTimeout"});
                    int retryCount = ConfigUtils.getInteger((RepositorySystemSession)session, (int)3, (String[])new String[]{"aether.connector.http.retryHandler.count." + repository.getId(), "aether.connector.http.retryHandler.count"});
                    long retryInterval = ConfigUtils.getLong((RepositorySystemSession)session, (long)5000L, (String[])new String[]{"aether.connector.http.retryHandler.interval." + repository.getId(), "aether.connector.http.retryHandler.interval"});
                    long retryIntervalMax = ConfigUtils.getLong((RepositorySystemSession)session, (long)300000L, (String[])new String[]{"aether.connector.http.retryHandler.intervalMax." + repository.getId(), "aether.connector.http.retryHandler.intervalMax"});
                    String serviceUnavailableCodesString = ConfigUtils.getString((RepositorySystemSession)session, (String)"429,503", (String[])new String[]{"aether.connector.http.retryHandler.serviceUnavailable." + repository.getId(), "aether.connector.http.retryHandler.serviceUnavailable"});
                    String retryHandlerName = ConfigUtils.getString((RepositorySystemSession)session, (String)HTTP_RETRY_HANDLER_NAME_STANDARD, (String[])new String[]{"aether.connector.http.retryHandler.name." + repository.getId(), HTTP_RETRY_HANDLER_NAME});
                    boolean retryHandlerRequestSentEnabled = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{"aether.connector.http.retryHandler.requestSentEnabled." + repository.getId(), HTTP_RETRY_HANDLER_REQUEST_SENT_ENABLED});
                    String userAgent = ConfigUtils.getString((RepositorySystemSession)session, (String)"Aether", (String[])new String[]{"aether.connector.userAgent"});
                    int maxRedirects = ConfigUtils.getInteger((RepositorySystemSession)session, (int)5, (String[])new String[]{"aether.connector.http.maxRedirects." + repository.getId(), "aether.connector.http.maxRedirects"});
                    boolean followRedirects = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.connector.http.followRedirects." + repository.getId(), "aether.connector.http.followRedirects"});
                    String expectContinue = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{"aether.connector.http.expectContinue." + repository.getId(), "aether.connector.http.expectContinue"});
                    Charset credentialsCharset = Charset.forName(credentialEncoding);
                    Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory(credentialsCharset)).register("Digest", (Object)new DigestSchemeFactory(credentialsCharset)).build();
                    SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(requestTimeout).build();
                    RequestConfig requestConfig = RequestConfig.custom().setMaxRedirects(maxRedirects).setRedirectsEnabled(followRedirects).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).setLocalAddress(MavenHttpClient4FactoryImpl.getHttpLocalAddress(session, repository)).setCookieSpec(HTTP_RETRY_HANDLER_NAME_STANDARD).setSocketTimeout(requestTimeout).setExpectContinueEnabled(Boolean.parseBoolean(expectContinue)).build();
                    if (HTTP_RETRY_HANDLER_NAME_STANDARD.equals(retryHandlerName)) {
                        retryHandler = new StandardHttpRequestRetryHandler(retryCount, retryHandlerRequestSentEnabled);
                    } else if (HTTP_RETRY_HANDLER_NAME_DEFAULT.equals(retryHandlerName)) {
                        retryHandler = new DefaultHttpRequestRetryHandler(retryCount, retryHandlerRequestSentEnabled);
                    } else {
                        throw new IllegalArgumentException("Unsupported parameter aether.connector.http.retryHandler.name value: " + retryHandlerName);
                    }
                    HashSet<Integer> serviceUnavailableCodes = new HashSet<Integer>();
                    try {
                        for (String code : ConfigUtils.parseCommaSeparatedUniqueNames((String)serviceUnavailableCodesString)) {
                            serviceUnavailableCodes.add(Integer.parseInt(code));
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal HTTP codes for aether.connector.http.retryHandler.serviceUnavailable (list of integers): " + serviceUnavailableCodesString);
                    }
                    ResolverServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy = new ResolverServiceUnavailableRetryStrategy(retryCount, retryInterval, retryIntervalMax, serviceUnavailableCodes);
                    HttpClientBuilder builder = HttpClientBuilder.create().setUserAgent(userAgent).setRedirectStrategy((RedirectStrategy)LaxRedirectStrategy.INSTANCE).setDefaultSocketConfig(socketConfig).setDefaultRequestConfig(requestConfig).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)serviceUnavailableRetryStrategy).setRetryHandler((HttpRequestRetryHandler)retryHandler).setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setConnectionManager(connectionManager).setConnectionManagerShared(true).setDefaultCredentialsProvider(MavenHttpClient4FactoryImpl.toCredentialsProvider(server, repoAuthContext, proxy, proxyAuthContext)).setProxy(proxy);
                    boolean useSystemProperties = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{"aether.connector.http.useSystemProperties." + repository.getId(), USE_SYSTEM_PROPERTIES});
                    if (useSystemProperties) {
                        builder.useSystemProperties();
                    }
                    if (!(reuseConnections = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.connector.http.reuseConnections." + repository.getId(), "aether.connector.http.reuseConnections"}))) {
                        builder.setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE);
                    }
                    httpClientBuilder = builder;
                    if (proxyAuthContext == null) break block25;
                }
                catch (Throwable throwable) {
                    if (proxyAuthContext != null) {
                        try {
                            proxyAuthContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                proxyAuthContext.close();
            }
            return httpClientBuilder;
        }
    }

    protected static InetAddress getHttpLocalAddress(RepositorySystemSession session, RemoteRepository repository) {
        String bindAddress = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{"aether.connector.bind.address." + repository.getId(), BIND_ADDRESS});
        if (bindAddress == null) {
            return null;
        }
        try {
            return InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("Given bind address (" + bindAddress + ") cannot be resolved for remote repository " + repository, uhe);
        }
    }

    protected static HttpHost toHost(Proxy proxy) {
        HttpHost host = null;
        if (proxy != null) {
            host = new HttpHost(proxy.getHost(), proxy.getPort());
        }
        return host;
    }

    protected static CredentialsProvider toCredentialsProvider(HttpHost server, AuthenticationContext serverAuthCtx, HttpHost proxy, AuthenticationContext proxyAuthCtx) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        if (serverAuthCtx != null) {
            AuthScope basicScope = new AuthScope(server.getHostName(), -1);
            provider.setCredentials(basicScope, MavenHttpClient4FactoryImpl.newCredentials(serverAuthCtx));
        }
        if (proxy != null && proxyAuthCtx != null) {
            AuthScope proxyScope = new AuthScope(proxy.getHostName(), proxy.getPort());
            provider.setCredentials(proxyScope, MavenHttpClient4FactoryImpl.newCredentials(proxyAuthCtx));
        }
        return provider;
    }

    protected static Credentials newCredentials(AuthenticationContext authContext) {
        String username = authContext.get("username");
        if (username == null) {
            return null;
        }
        String password = authContext.get("password");
        return new UsernamePasswordCredentials(username, password);
    }

    protected static HttpClientConnectionManager newConnectionManager(ConnMgrConfig connMgrConfig) {
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        int connectionMaxTtlSeconds = 300;
        int maxConnectionsPerRoute = 50;
        if (connMgrConfig == null) {
            registryBuilder.register("https", (Object)SSLConnectionSocketFactory.getSystemSocketFactory());
        } else {
            connectionMaxTtlSeconds = connMgrConfig.connectionMaxTtlSeconds;
            maxConnectionsPerRoute = connMgrConfig.maxConnectionsPerRoute;
            SSLSocketFactory sslSocketFactory = connMgrConfig.context != null ? connMgrConfig.context.getSocketFactory() : null;
            HostnameVerifier hostnameVerifier = connMgrConfig.verifier;
            if (HTTP_RETRY_HANDLER_NAME_DEFAULT.equals(connMgrConfig.httpsSecurityMode)) {
                if (sslSocketFactory == null) {
                    sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                }
                if (hostnameVerifier == null) {
                    hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
                }
            } else if ("insecure".equals(connMgrConfig.httpsSecurityMode)) {
                if (sslSocketFactory == null) {
                    try {
                        sslSocketFactory = new SSLContextBuilder().loadTrustMaterial(null, (chain, auth) -> true).build().getSocketFactory();
                    }
                    catch (Exception e) {
                        throw new SSLInitializationException("Could not configure '" + connMgrConfig.httpsSecurityMode + "' HTTPS security mode", (Throwable)e);
                    }
                }
                if (hostnameVerifier == null) {
                    hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                }
            } else {
                throw new IllegalArgumentException("Unsupported '" + connMgrConfig.httpsSecurityMode + "' HTTPS security mode.");
            }
            registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(sslSocketFactory, connMgrConfig.protocols, connMgrConfig.cipherSuites, hostnameVerifier));
        }
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager((HttpClientConnectionOperator)new DefaultHttpClientConnectionOperator((Lookup)registryBuilder.build(), (SchemePortResolver)DefaultSchemePortResolver.INSTANCE, (DnsResolver)SystemDefaultDnsResolver.INSTANCE), (HttpConnectionFactory)ManagedHttpClientConnectionFactory.INSTANCE, (long)connectionMaxTtlSeconds, TimeUnit.SECONDS);
        connMgr.setMaxTotal(maxConnectionsPerRoute * 2);
        connMgr.setDefaultMaxPerRoute(maxConnectionsPerRoute);
        return connMgr;
    }

    protected static class ConnMgrConfig {
        private static final String CIPHER_SUITES = "https.cipherSuites";
        private static final String PROTOCOLS = "https.protocols";
        private final SSLContext context;
        private final HostnameVerifier verifier;
        private final String[] cipherSuites;
        private final String[] protocols;
        private final String httpsSecurityMode;
        private final int connectionMaxTtlSeconds;
        private final int maxConnectionsPerRoute;

        protected ConnMgrConfig(RepositorySystemSession session, AuthenticationContext authContext, String httpsSecurityMode, int connectionMaxTtlSeconds, int maxConnectionsPerRoute) {
            this.context = authContext != null ? (SSLContext)authContext.get("ssl.context", SSLContext.class) : null;
            this.verifier = authContext != null ? (HostnameVerifier)authContext.get("ssl.hostnameVerifier", HostnameVerifier.class) : null;
            this.cipherSuites = ConnMgrConfig.split(ConnMgrConfig.get(session, CIPHER_SUITES));
            this.protocols = ConnMgrConfig.split(ConnMgrConfig.get(session, PROTOCOLS));
            this.httpsSecurityMode = httpsSecurityMode;
            this.connectionMaxTtlSeconds = connectionMaxTtlSeconds;
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        }

        private static String get(RepositorySystemSession session, String key) {
            String value = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{"aether.connector." + key, key});
            if (value == null) {
                value = System.getProperty(key);
            }
            return value;
        }

        private static String[] split(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            return value.split(",+");
        }
    }

    protected static class ResolverServiceUnavailableRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        protected final int retryCount;
        protected final long retryInterval;
        protected final long retryIntervalMax;
        protected final Set<Integer> serviceUnavailableHttpCodes;
        protected static final ThreadLocal<Long> RETRY_INTERVAL_HOLDER = new ThreadLocal();

        protected ResolverServiceUnavailableRetryStrategy(int retryCount, long retryInterval, long retryIntervalMax, Set<Integer> serviceUnavailableHttpCodes) {
            if (retryCount < 0) {
                throw new IllegalArgumentException("retryCount must be >= 0");
            }
            if (retryInterval < 0L) {
                throw new IllegalArgumentException("retryInterval must be >= 0");
            }
            if (retryIntervalMax < 0L) {
                throw new IllegalArgumentException("retryIntervalMax must be >= 0");
            }
            this.retryCount = retryCount;
            this.retryInterval = retryInterval;
            this.retryIntervalMax = retryIntervalMax;
            this.serviceUnavailableHttpCodes = Objects.requireNonNull(serviceUnavailableHttpCodes);
        }

        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            Long retryInterval;
            boolean retry;
            boolean bl = retry = executionCount <= this.retryCount && this.serviceUnavailableHttpCodes.contains(response.getStatusLine().getStatusCode());
            if (retry && (retryInterval = this.retryInterval(response, executionCount, context)) != null) {
                RETRY_INTERVAL_HOLDER.set(retryInterval);
                return true;
            }
            RETRY_INTERVAL_HOLDER.remove();
            return false;
        }

        protected Long retryInterval(HttpResponse httpResponse, int executionCount, HttpContext httpContext) {
            Long result = null;
            Header header = httpResponse.getFirstHeader("Retry-After");
            if (header != null && header.getValue() != null) {
                String headerValue = header.getValue();
                if (headerValue.contains(":")) {
                    Date when = DateUtils.parseDate((String)headerValue);
                    if (when != null) {
                        result = Math.max(when.getTime() - System.currentTimeMillis(), 0L);
                    }
                } else {
                    try {
                        result = Long.parseLong(headerValue) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (result == null) {
                result = (long)executionCount * this.retryInterval;
            }
            if (result > this.retryIntervalMax) {
                return null;
            }
            return result;
        }

        public long getRetryInterval() {
            Long ri = RETRY_INTERVAL_HOLDER.get();
            if (ri == null) {
                return 0L;
            }
            RETRY_INTERVAL_HOLDER.remove();
            return ri;
        }
    }
}

