/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.extensions.mmr.internal;

import eu.maveniverse.maven.mima.extensions.mmr.ModelRequest;
import eu.maveniverse.maven.mima.extensions.mmr.ModelResponse;
import eu.maveniverse.maven.mima.extensions.mmr.internal.ModelResolverImpl;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.interpolation.StringVisitorModelInterpolator;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.apache.maven.repository.internal.RequestTraceHelper;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenModelReaderImpl {
    private final RepositorySystem repositorySystem;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final RepositoryEventDispatcher repositoryEventDispatcher;
    private final ModelBuilder modelBuilder;
    private final StringVisitorModelInterpolator stringVisitorModelInterpolator;
    private final List<RemoteRepository> repositories;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MavenModelReaderImpl(RepositorySystem repositorySystem, RemoteRepositoryManager remoteRepositoryManager, RepositoryEventDispatcher repositoryEventDispatcher, ModelBuilder modelBuilder, StringVisitorModelInterpolator stringVisitorModelInterpolator, List<RemoteRepository> repositories) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager);
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher);
        this.modelBuilder = Objects.requireNonNull(modelBuilder);
        this.stringVisitorModelInterpolator = Objects.requireNonNull(stringVisitorModelInterpolator);
        this.repositories = Objects.requireNonNull(repositories);
    }

    public ModelResponse readModel(RepositorySystemSession session, ModelRequest request) throws VersionResolutionException, ArtifactResolutionException, ArtifactDescriptorException {
        return this.loadPom(session, request);
    }

    private ModelResponse loadPom(RepositorySystemSession session, ModelRequest request) throws VersionResolutionException, ArtifactResolutionException, ArtifactDescriptorException {
        List repositories = this.repositories;
        if (request.getRepositories() != null) {
            repositories = this.repositorySystem.newResolutionRepositories(session, request.getRepositories());
        }
        ArtifactDescriptorRequest artifactDescriptorRequest = new ArtifactDescriptorRequest();
        artifactDescriptorRequest.setArtifact(request.getArtifact());
        artifactDescriptorRequest.setRepositories(repositories);
        artifactDescriptorRequest.setRequestContext(request.getRequestContext());
        artifactDescriptorRequest.setTrace(request.getTrace());
        ArtifactDescriptorResult artifactDescriptorResult = new ArtifactDescriptorResult(artifactDescriptorRequest);
        RequestTrace trace = RequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        Artifact a = request.getArtifact();
        Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact((Artifact)a);
        if (a.getFile() != null) {
            pomArtifact = pomArtifact.setFile(a.getFile());
        }
        ArtifactResult resolveResult = null;
        if (pomArtifact.getFile() == null) {
            try {
                VersionRequest versionRequest = new VersionRequest(a, repositories, request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.repositorySystem.resolveVersion(session, versionRequest);
                a = a.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(pomArtifact, repositories, request.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.repositorySystem.resolveVersion(session, versionRequest);
                pomArtifact = pomArtifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e) {
                artifactDescriptorResult.addException((Exception)((Object)e));
                throw e;
            }
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, repositories, request.getRequestContext());
                resolveRequest.setTrace(trace);
                resolveResult = this.repositorySystem.resolveArtifact(session, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                artifactDescriptorResult.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e) {
                if (e.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(session, trace, a, (Exception)e.getCause());
                }
                artifactDescriptorResult.addException((Exception)((Object)e));
                throw e;
            }
        }
        try {
            DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
            modelRequest.setValidationLevel(0);
            modelRequest.setProcessPlugins(false);
            modelRequest.setTwoPhaseBuilding(false);
            modelRequest.setLocationTracking(true);
            modelRequest.setSystemProperties(this.toProperties(session.getUserProperties(), session.getSystemProperties()));
            modelRequest.setUserProperties(new Properties());
            modelRequest.setModelResolver((ModelResolver)new ModelResolverImpl(this.repositorySystem, session, trace.newChild((Object)modelRequest), request.getRequestContext(), this.remoteRepositoryManager, repositories));
            if (resolveResult != null && resolveResult.getRepository() instanceof WorkspaceRepository) {
                modelRequest.setPomFile(pomArtifact.getFile());
            } else {
                modelRequest.setModelSource((ModelSource)new FileModelSource(pomArtifact.getFile()));
                modelRequest.setPomFile(pomArtifact.getFile());
            }
            ModelBuildingResult modelResult = this.modelBuilder.build((ModelBuildingRequest)modelRequest);
            if (!modelResult.getProblems().isEmpty()) {
                List problems = modelResult.getProblems();
                if (this.logger.isDebugEnabled()) {
                    String problem = problems.size() == 1 ? "problem" : "problems";
                    String problemPredicate = problem + (problems.size() == 1 ? " was" : " were");
                    String message = String.format("%s %s encountered while building the effective model for %s during %s\n", problems.size(), problemPredicate, request.getArtifact(), RequestTraceHelper.interpretTrace((boolean)true, (RequestTrace)request.getTrace()));
                    message = message + StringUtils.capitalizeFirstLetter((String)problem);
                    for (ModelProblem modelProblem : problems) {
                        message = message + String.format("\n* %s @ %s", modelProblem.getMessage(), ModelProblemUtils.formatLocation((ModelProblem)modelProblem, null));
                    }
                    this.logger.warn(message);
                } else {
                    this.logger.warn("{} {} encountered while building the effective model for {} during {} (use -X to see details)", new Object[]{problems.size(), problems.size() == 1 ? "problem was" : "problems were", request.getArtifact(), RequestTraceHelper.interpretTrace((boolean)false, (RequestTrace)request.getTrace())});
                }
            }
            modelRequest.getUserProperties().putAll((Map<?, ?>)modelResult.getEffectiveModel().getProperties());
            modelRequest.getUserProperties().put("project.groupId", modelResult.getEffectiveModel().getGroupId());
            modelRequest.getUserProperties().put("project.artifactId", modelResult.getEffectiveModel().getArtifactId());
            modelRequest.getUserProperties().put("project.version", modelResult.getEffectiveModel().getVersion());
            modelRequest.getUserProperties().putAll((Map<?, ?>)modelResult.getEffectiveModel().getProperties());
            return new ModelResponse(modelResult.getRawModel().clone(), modelResult.getEffectiveModel().clone(), artifactDescriptorResult.getRepository(), m -> {
                ArtifactDescriptorResult r = new ArtifactDescriptorResult(artifactDescriptorRequest);
                r.setRepository(artifactDescriptorResult.getRepository());
                return MavenModelReaderImpl.populateResult(session, r, m);
            }, modelResult.getModelIds(), arg_0 -> ((ModelBuildingResult)modelResult).getRawModel(arg_0), arg_0 -> this.lambda$loadPom$2((ModelBuildingRequest)modelRequest, arg_0));
        }
        catch (ModelBuildingException e) {
            for (ModelProblem problem : e.getProblems()) {
                if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                artifactDescriptorResult.addException(problem.getException());
                throw new ArtifactDescriptorException(artifactDescriptorResult);
            }
            this.invalidDescriptor(session, trace, a, (Exception)((Object)e));
            artifactDescriptorResult.addException((Exception)((Object)e));
            throw new ArtifactDescriptorException(artifactDescriptorResult);
        }
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    private void missingDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void invalidDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private static ArtifactDescriptorResult populateResult(RepositorySystemSession session, ArtifactDescriptorResult result, Model model) {
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        for (Repository r : model.getRepositories()) {
            result.addRepository(ArtifactDescriptorUtils.toRemoteRepository((Repository)r));
        }
        for (Object dependency : model.getDependencies()) {
            result.addDependency(MavenModelReaderImpl.convert((Dependency)dependency, stereotypes));
        }
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            for (Dependency dependency : mgmt.getDependencies()) {
                result.addManagedDependency(MavenModelReaderImpl.convert(dependency, stereotypes));
            }
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("model", model);
        Prerequisites prerequisites = model.getPrerequisites();
        if (prerequisites != null) {
            properties.put("prerequisites.maven", prerequisites.getMaven());
        }
        List licenses = model.getLicenses();
        properties.put("license.count", licenses.size());
        for (int i = 0; i < licenses.size(); ++i) {
            License license = (License)licenses.get(i);
            properties.put("license." + i + ".name", license.getName());
            properties.put("license." + i + ".url", license.getUrl());
            properties.put("license." + i + ".comments", license.getComments());
            properties.put("license." + i + ".distribution", license.getDistribution());
        }
        result.setProperties(properties);
        MavenModelReaderImpl.setArtifactProperties(result, model);
        return result;
    }

    private static org.eclipse.aether.graph.Dependency convert(Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && !dependency.getSystemPath().isEmpty();
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>(dependency.getExclusions().size());
        for (org.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(MavenModelReaderImpl.convert(exclusion));
        }
        return new org.eclipse.aether.graph.Dependency((Artifact)artifact, dependency.getScope(), dependency.getOptional() != null ? Boolean.valueOf(dependency.isOptional()) : null, exclusions);
    }

    private static Exclusion convert(org.apache.maven.model.Exclusion exclusion) {
        return new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private static void setArtifactProperties(ArtifactDescriptorResult result, Model model) {
        String downloadUrl = null;
        DistributionManagement distMgmt = model.getDistributionManagement();
        if (distMgmt != null) {
            downloadUrl = distMgmt.getDownloadUrl();
        }
        if (downloadUrl != null && !downloadUrl.isEmpty()) {
            Artifact artifact = result.getArtifact();
            HashMap<String, String> props = new HashMap<String, String>(artifact.getProperties());
            props.put("downloadUrl", downloadUrl);
            result.setArtifact(artifact.setProperties(props));
        }
    }

    private /* synthetic */ Model lambda$loadPom$2(ModelBuildingRequest modelRequest, Model m) {
        return this.stringVisitorModelInterpolator.interpolateModel(m.clone(), Paths.get("", new String[0]).toFile(), modelRequest, req -> {});
    }
}

