/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.shared.core.fs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DirectoryLocker {
    public static DirectoryLocker INSTANCE = new DirectoryLocker();
    private final HashMap<Path, FileChannel> fileChannels = new HashMap();
    private final HashMap<Path, FileLock> fileLocks = new HashMap();
    private final HashMap<Path, ArrayDeque<Boolean>> references = new HashMap();

    private DirectoryLocker() {
    }

    public synchronized void lockDirectory(Path directory, boolean exclusiveAccess) throws IOException {
        Objects.requireNonNull(directory, "directory");
        Path lockFile = directory.resolve(".lock");
        if (!Files.isRegularFile(lockFile, new LinkOption[0])) {
            try {
                Files.createFile(lockFile, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        if (exclusiveAccess && this.fileChannels.containsKey(directory)) {
            throw new IOException("Failed to gain exclusive access to storage: " + directory);
        }
        try {
            AtomicBoolean acted = new AtomicBoolean(false);
            FileChannel channel = this.fileChannels.computeIfAbsent(directory, p -> {
                try {
                    FileChannel c = FileChannel.open(lockFile, StandardOpenOption.READ, StandardOpenOption.WRITE);
                    acted.set(true);
                    return c;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            FileLock lock = this.fileLocks.computeIfAbsent(directory, p -> {
                try {
                    return channel.tryLock(0L, Long.MAX_VALUE, !exclusiveAccess);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            if (lock == null || lock.isShared() == exclusiveAccess) {
                if (lock != null) {
                    lock.release();
                }
                if (acted.get()) {
                    this.fileChannels.get(directory).close();
                }
                throw new IOException("Failed to gain " + (exclusiveAccess ? "exclusive" : "shared") + " access to storage: " + directory);
            }
            this.references.computeIfAbsent(directory, p -> new ArrayDeque()).push(acted.get());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public synchronized void unlockDirectory(Path directory) throws IOException {
        Objects.requireNonNull(directory, "directory");
        ArrayDeque<Boolean> refs = this.references.get(directory);
        if (refs == null) {
            throw new IOException("Directory was not locked: " + directory);
        }
        refs.pop();
        if (refs.isEmpty()) {
            try {
                this.fileLocks.remove(directory).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.fileChannels.remove(directory).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.references.remove(directory);
        }
    }
}

