/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.shared.core.maven;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;

public final class MavenUtils {
    private MavenUtils() {
    }

    public static HashMap<String, String> toMap(Properties properties) {
        Objects.requireNonNull(properties, "properties");
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Map<String, String>> discoverProperties(ClassLoader classLoader, String resourceName) {
        Properties props = new Properties();
        try (InputStream is = classLoader.getResourceAsStream(resourceName);){
            if (is == null) return Optional.empty();
            props.load(is);
            Optional<Map<String, String>> optional = Optional.of(MavenUtils.toMap(props));
            return optional;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static String discoverArtifactVersion(ClassLoader classLoader, String groupId, String artifactId, String defVersion) {
        String version = MavenUtils.discoverProperties(classLoader, "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties").orElseGet(Collections::emptyMap).getOrDefault("version", defVersion);
        if (version != null && (version = version.trim()).startsWith("${")) {
            version = defVersion;
        }
        return version;
    }
}

