/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogPartition;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.RelationalChangeRecordEmitter;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableSchema;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import java.io.Serializable;
import org.apache.kafka.connect.data.Struct;

public class BinlogChangeRecordEmitter<P extends BinlogPartition>
extends RelationalChangeRecordEmitter<P> {
    private final Envelope.Operation operation;
    private final OffsetContext offset;
    private final Object[] before;
    private final Object[] after;

    public BinlogChangeRecordEmitter(P partition, OffsetContext offset, Clock clock, Envelope.Operation operation, Serializable[] before, Serializable[] after, BinlogConnectorConfig connectorConfig) {
        super(partition, offset, clock, (RelationalDatabaseConnectorConfig)connectorConfig);
        this.offset = offset;
        this.operation = operation;
        this.before = before;
        this.after = after;
    }

    public OffsetContext getOffset() {
        return this.offset;
    }

    public Envelope.Operation getOperation() {
        return this.operation;
    }

    protected Object[] getOldColumnValues() {
        return this.before;
    }

    protected Object[] getNewColumnValues() {
        return this.after;
    }

    protected void emitTruncateRecord(ChangeRecordEmitter.Receiver<P> receiver, TableSchema schema) throws InterruptedException {
        Struct envelope = schema.getEnvelopeSchema().truncate(this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        receiver.changeRecord((Partition)((BinlogPartition)this.getPartition()), (DataCollectionSchema)schema, Envelope.Operation.TRUNCATE, null, envelope, this.getOffset(), null);
    }
}

