/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import java.math.BigDecimal;

public class BinlogUnsignedIntegerConverter {
    private static final short TINYINT_MAX_VALUE = 255;
    private static final int SMALLINT_MAX_VALUE = 65535;
    private static final int MEDIUMINT_MAX_VALUE = 0xFFFFFF;
    private static final long INT_MAX_VALUE = 0xFFFFFFFFL;
    private static final BigDecimal BIGINT_MAX_VALUE = new BigDecimal("18446744073709551615");
    private static final short TINYINT_CORRECTION = 256;
    private static final int SMALLINT_CORRECTION = 65536;
    private static final int MEDIUMINT_CORRECTION = 0x1000000;
    private static final long INT_CORRECTION = 0x100000000L;
    private static final BigDecimal BIGINT_CORRECTION = BIGINT_MAX_VALUE.add(BigDecimal.ONE);

    public static short convertUnsignedTinyint(short originalNumber) {
        if (originalNumber < 0) {
            return (short)(originalNumber + 256);
        }
        return originalNumber;
    }

    public static int convertUnsignedSmallint(int originalNumber) {
        if (originalNumber < 0) {
            return originalNumber + 65536;
        }
        return originalNumber;
    }

    public static int convertUnsignedMediumint(int originalNumber) {
        if (originalNumber < 0) {
            return originalNumber + 0x1000000;
        }
        return originalNumber;
    }

    public static long convertUnsignedInteger(long originalNumber) {
        if (originalNumber < 0L) {
            return originalNumber + 0x100000000L;
        }
        return originalNumber;
    }

    public static BigDecimal convertUnsignedBigint(BigDecimal originalNumber) {
        if (originalNumber.compareTo(BigDecimal.ZERO) == -1) {
            return originalNumber.add(BIGINT_CORRECTION);
        }
        return originalNumber;
    }

    private BinlogUnsignedIntegerConverter() {
    }
}

