/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.testcontainers;

import java.io.IOException;
import java.net.ServerSocket;
import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class OxiaContainer
extends GenericContainer<OxiaContainer> {
    public static final int OXIA_PORT = 6648;
    public static final int METRICS_PORT = 8080;
    private static final int DEFAULT_SHARDS = 1;
    @NonNull
    private final DockerImageName imageName;
    private final int shards;
    public static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"oxia/oxia:main");

    public OxiaContainer(@NonNull DockerImageName imageName) {
        this(imageName, 1, false);
        if (imageName == null) {
            throw new NullPointerException("imageName is marked non-null but is null");
        }
    }

    public OxiaContainer(@NonNull DockerImageName imageName, int shards) {
        this(imageName, shards, false);
        if (imageName == null) {
            throw new NullPointerException("imageName is marked non-null but is null");
        }
    }

    public OxiaContainer(@NonNull DockerImageName imageName, int shards, boolean fixedServicePort) {
        super(imageName);
        if (imageName == null) {
            throw new NullPointerException("imageName is marked non-null but is null");
        }
        this.imageName = imageName;
        this.shards = shards;
        if (shards <= 0) {
            throw new IllegalArgumentException("shards must be greater than zero");
        }
        if (fixedServicePort) {
            int freePort = 0;
            try {
                freePort = OxiaContainer.findFreePort();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.addFixedExposedPort(freePort, 6648);
            this.addExposedPorts(new int[]{8080});
        } else {
            this.addExposedPorts(new int[]{6648, 8080});
        }
        this.setCommand(new String[]{"oxia", "standalone", "--shards=" + shards});
        this.waitingFor(Wait.forHttp((String)"/metrics").forPort(8080).forStatusCode(200).withStartupTimeout(Duration.ofSeconds(30L)));
    }

    private static int findFreePort() throws IOException {
        int i = 10000;
        while (i <= 20000) {
            int n;
            ServerSocket socket = new ServerSocket(i);
            try {
                n = i;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ++i;
                }
            }
            socket.close();
            return n;
        }
        throw new IOException("No free port found in the specified range");
    }

    public String getServiceAddress() {
        return this.getHost() + ":" + this.getMappedPort(6648);
    }

    public String getMetricsUrl() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(8080) + "/metrics";
    }

    @Generated
    private OxiaContainer withImageName(@NonNull DockerImageName imageName) {
        if (imageName == null) {
            throw new NullPointerException("imageName is marked non-null but is null");
        }
        return this.imageName == imageName ? this : new OxiaContainer(imageName, this.shards);
    }

    @Generated
    public OxiaContainer withShards(int shards) {
        return this.shards == shards ? this : new OxiaContainer(this.imageName, shards);
    }
}

