/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.azuremonitor;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.util.function.Function;

public interface AzureMonitorConfig
extends StepRegistryConfig {
    default public String prefix() {
        return "azuremonitor";
    }

    @Nullable
    @Deprecated
    default public String instrumentationKey() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"instrumentationKey").get();
    }

    @Nullable
    default public String connectionString() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"connectionString").orElseGet(() -> {
            String instrumentationKey = this.instrumentationKey();
            if (instrumentationKey == null) {
                return null;
            }
            return "InstrumentationKey=" + instrumentationKey;
        });
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), MeterRegistryConfigValidator.check((String)"connectionString", AzureMonitorConfig::connectionString)});
    }
}

