/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubating.maven.h3spec;

import io.netty.incubating.maven.h3spec.H3Spec;
import io.netty.incubating.maven.h3spec.H3SpecCaseResult;
import io.netty.incubating.maven.h3spec.H3SpecResult;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Mojo(name="h3spec", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class H3SpecMojo
extends AbstractMojo {
    @Parameter(defaultValue="-1", property="port", required=true)
    private int port;
    @Parameter(property="excludeSpecs")
    private List<String> excludeSpecs;
    @Parameter(property="mainClass", required=true)
    private String mainClass;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="delay", defaultValue="1000", required=true)
    private long delay;
    @Parameter(property="readyMessage")
    private String readyMessage;
    @Parameter(property="timeoutMillis", defaultValue="1000")
    private long timeoutMillis;
    @Parameter(property="debug", defaultValue="false")
    private boolean debug;
    @Component
    private MavenProject project;

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getTestClasspathElements();
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            classpathElements.add(this.project.getBuild().getTestOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip execution of h3spec-maven-plugin");
            return;
        }
        AtomicReference error = new AtomicReference();
        Thread runner = null;
        try {
            String host;
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                this.getLog().debug((CharSequence)"Unable to detect localhost address, using 127.0.0.1 as fallback");
                host = "127.0.0.1";
            }
            if (this.port == -1) {
                this.port = this.findRandomOpenPortOnAllLocalInterfaces();
            }
            CountDownLatch latch = new CountDownLatch(1);
            boolean hasReadyMessage = !this.readyMessage.isEmpty();
            final CountDownLatch readyMessageLatch = new CountDownLatch(hasReadyMessage ? 1 : 0);
            runner = new Thread(() -> {
                PrintStream oldOut;
                PrintStream printStream = oldOut = hasReadyMessage ? System.out : null;
                if (oldOut != null) {
                    FilterOutputStream filterOut = new FilterOutputStream(oldOut){

                        @Override
                        public void write(byte[] b, int off, int len) throws IOException {
                            if (new String(b, off, len).contains(H3SpecMojo.this.readyMessage)) {
                                readyMessageLatch.countDown();
                            }
                            super.write(b, off, len);
                        }
                    };
                    BufferedOutputStream bufOut = new BufferedOutputStream(filterOut);
                    PrintStream printStream2 = new PrintStream(bufOut, true);
                    System.setOut(printStream2);
                }
                try {
                    Thread.currentThread().setContextClassLoader(this.getClassLoader());
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.mainClass);
                    Method main = clazz.getMethod("main", String[].class);
                    latch.countDown();
                    main.invoke(null, new Object[]{new String[]{String.valueOf(this.port)}});
                }
                catch (Throwable e) {
                    error.set(e);
                    latch.countDown();
                }
                finally {
                    if (oldOut != null) {
                        System.setOut(oldOut);
                    }
                }
            });
            runner.setDaemon(true);
            runner.start();
            try {
                latch.await();
                Throwable cause = (Throwable)error.get();
                if (cause != null) {
                    throw cause;
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                readyMessageLatch.await();
                if (this.excludeSpecs == null) {
                    this.excludeSpecs = Collections.emptyList();
                }
                File outputDirectory = new File(this.project.getBuild().getDirectory());
                H3Spec.Config config = new H3Spec.Config(host, this.port, this.excludeSpecs, this.timeoutMillis, this.debug);
                H3SpecResult result = H3Spec.execute(outputDirectory, config);
                File reportsDirectory = new File(outputDirectory, "h3spec-reports");
                if (!reportsDirectory.exists()) {
                    this.getLog().debug((CharSequence)("Reports directory " + reportsDirectory.getAbsolutePath() + " does not exist, try creating it..."));
                    if (reportsDirectory.mkdirs()) {
                        this.getLog().debug((CharSequence)("Reports directory " + reportsDirectory.getAbsolutePath() + " created."));
                    } else {
                        this.getLog().debug((CharSequence)"Failed to create report directory");
                    }
                }
                File junitFile = new File(reportsDirectory, "TEST-h3spec.xml");
                if (this.writeJUnitXmlReport(result.results(), junitFile)) {
                    StringBuilder sb = new StringBuilder("\nFailed test cases:\n");
                    for (H3SpecCaseResult r : result.results()) {
                        if (!r.isFailure()) continue;
                        sb.append("\t");
                        sb.append(r.name()).append(" ").append(r.rfcSection());
                        sb.append("\n\n");
                    }
                    sb.append(result.failureDetails());
                    throw new MojoFailureException(sb.toString());
                }
                this.getLog().info((CharSequence)"All test cases passed.");
            }
            catch (Throwable e) {
                throw new MojoExecutionException("Failure during execution", e);
            }
        }
        finally {
            if (runner != null) {
                runner.interrupt();
            }
        }
    }

    private Integer findRandomOpenPortOnAllLocalInterfaces() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            Integer n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't find an open socket", e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    System.err.println("Can't close server socket.");
                }
            }
        }
    }

    private boolean writeJUnitXmlReport(List<H3SpecCaseResult> results, File junitFile) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        String className = ((Object)((Object)this)).getClass().getName();
        int failures = 0;
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("testsuite");
        rootElement.setAttribute("name", className);
        rootElement.setAttribute("tests", Integer.toString(results.size()));
        rootElement.setAttribute("errors", Integer.toString(0));
        rootElement.setAttribute("skipped", Integer.toString(0));
        for (H3SpecCaseResult r : results) {
            Element testcase = doc.createElement("testcase");
            testcase.setAttribute("classname", "H3Spec");
            testcase.setAttribute("name", r.name() + " " + r.rfcSection());
            if (r.isFailure()) {
                Element failure = doc.createElement("failure");
                failure.setAttribute("type", "behaviorMissmatch");
                testcase.appendChild(failure);
                ++failures;
            }
            rootElement.appendChild(testcase);
        }
        rootElement.setAttribute("failures", Integer.toString(failures));
        rootElement.setAttribute("time", "0");
        doc.appendChild(rootElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(junitFile);
        transformer.transform(source, result);
        return failures > 0;
    }
}

