/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.vectordata.transport;

import io.nosqlbench.nbdatatools.api.services.TransportScheme;
import io.nosqlbench.nbdatatools.api.transport.ChunkedTransportClient;
import io.nosqlbench.nbdatatools.api.transport.FetchResult;
import io.nosqlbench.nbdatatools.api.transport.StreamingFetchResult;
import io.nosqlbench.vectordata.transport.HttpStreamingFetchResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

@TransportScheme(value={"http", "https"})
public class HttpByteRangeFetcher
implements ChunkedTransportClient {
    private final OkHttpClient httpClient;
    private final String sourceUrl;
    private final AtomicReference<Long> cachedSize = new AtomicReference();
    private final AtomicReference<Boolean> cachedRangeSupport = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public HttpByteRangeFetcher(String url) {
        if (url == null || url.trim().isEmpty()) {
            throw new IllegalArgumentException("URL cannot be null or empty");
        }
        String trimmedUrl = url.trim();
        if (!trimmedUrl.toLowerCase().startsWith("http://") && !trimmedUrl.toLowerCase().startsWith("https://")) {
            throw new IllegalArgumentException("URL must be HTTP or HTTPS: " + url);
        }
        this.sourceUrl = trimmedUrl;
        this.httpClient = this.createOptimizedHttpClient();
    }

    private OkHttpClient createOptimizedHttpClient() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(200);
        dispatcher.setMaxRequestsPerHost(50);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(100, 5L, TimeUnit.MINUTES)).dispatcher(dispatcher);
        return builder.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1)).retryOnConnectionFailure(true).build();
    }

    public CompletableFuture<? extends FetchResult<?>> fetchRange(long offset, long length) throws IOException {
        this.validateNotClosed();
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset cannot be negative: " + offset);
        }
        if (length <= 0L) {
            throw new IllegalArgumentException("Length must be positive: " + length);
        }
        return CompletableFuture.supplyAsync(() -> {
            FetchResult fetchResult;
            block10: {
                long endOffset = offset + length - 1L;
                Request request = new Request.Builder().url(this.sourceUrl).addHeader("Range", "bytes=" + offset + "-" + endOffset).build();
                Response response = this.httpClient.newCall(request).execute();
                try {
                    this.validateResponse(response, offset, length);
                    ResponseBody body = response.body();
                    if (body == null) {
                        throw new IOException("Response body is null");
                    }
                    byte[] data = body.bytes();
                    if ((long)data.length != length) {
                        throw new IOException("Expected " + length + " bytes but received " + data.length);
                    }
                    fetchResult = new FetchResult(ByteBuffer.wrap(data), offset, length);
                    if (response == null) break block10;
                }
                catch (Throwable t$) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to fetch range (HttpByteRangeFetcher1) [" + offset + "-" + (offset + length - 1L) + "]", e);
                    }
                }
                response.close();
            }
            return fetchResult;
        });
    }

    public CompletableFuture<StreamingFetchResult> fetchRangeStreaming(long offset, long length) throws IOException {
        this.validateNotClosed();
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset cannot be negative: " + offset);
        }
        if (length <= 0L) {
            throw new IllegalArgumentException("Length must be positive: " + length);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                long endOffset = offset + length - 1L;
                Request request = new Request.Builder().url(this.sourceUrl).addHeader("Range", "bytes=" + offset + "-" + endOffset).build();
                Response response = this.httpClient.newCall(request).execute();
                try {
                    this.validateResponse(response, offset, length);
                    ResponseBody body = response.body();
                    if (body == null) {
                        response.close();
                        throw new IOException("Response body is null");
                    }
                    return new HttpStreamingFetchResult(response, body, offset, length, this.sourceUrl);
                }
                catch (Exception e) {
                    response.close();
                    throw e;
                }
            }
            catch (IOException e) {
                throw new CompletionException("Failed to fetch range (HttpByteRangeFetcher2) [" + offset + "-" + (offset + length - 1L) + "]", e);
            }
        });
    }

    public CompletableFuture<Long> getSize() throws IOException {
        this.validateNotClosed();
        Long cached = this.cachedSize.get();
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        return CompletableFuture.supplyAsync(() -> {
            Long size;
            IOException lastError = null;
            try {
                size = this.tryResolveSizeWithHead();
                if (size != null) {
                    return size;
                }
            }
            catch (IOException e) {
                lastError = e;
            }
            try {
                size = this.tryResolveSizeWithRangeProbe();
                if (size != null) {
                    return size;
                }
            }
            catch (IOException e) {
                if (lastError != null) {
                    e.addSuppressed(lastError);
                }
                lastError = e;
            }
            if (lastError == null) {
                lastError = new IOException("Server did not provide enough metadata to determine content size");
            }
            throw new RuntimeException("Failed to determine content size", lastError);
        });
    }

    public boolean supportsRangeRequests() {
        boolean bl;
        block9: {
            Boolean cached = this.cachedRangeSupport.get();
            if (cached != null) {
                return cached;
            }
            Request headRequest = new Request.Builder().url(this.sourceUrl).head().build();
            Response response = this.httpClient.newCall(headRequest).execute();
            try {
                String acceptRanges = response.header("Accept-Ranges");
                boolean supportsRanges = acceptRanges != null && "bytes".equalsIgnoreCase(acceptRanges.trim());
                this.cachedRangeSupport.set(supportsRanges);
                bl = supportsRanges;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.cachedRangeSupport.set(false);
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    private Long tryResolveSizeWithHead() throws IOException {
        Request headRequest = new Request.Builder().url(this.sourceUrl).head().build();
        try (Response response = this.httpClient.newCall(headRequest).execute();){
            String contentLength;
            if (!response.isSuccessful()) {
                throw new IOException("HEAD request failed with status: " + response.code());
            }
            String acceptRanges = response.header("Accept-Ranges");
            if (acceptRanges != null) {
                this.cachedRangeSupport.set("bytes".equalsIgnoreCase(acceptRanges.trim()));
            }
            if ((contentLength = response.header("Content-Length")) == null) {
                Long l = null;
                return l;
            }
            long size = Long.parseLong(contentLength);
            this.cachedSize.set(size);
            Long l = size;
            return l;
        }
    }

    /*
     * Exception decompiling
     */
    private Long tryResolveSizeWithRangeProbe() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Long parseSizeFromContentRange(String contentRange) throws IOException {
        int slashIndex = contentRange.lastIndexOf(47);
        if (slashIndex < 0 || slashIndex == contentRange.length() - 1) {
            throw new IOException("Invalid Content-Range header: " + contentRange);
        }
        String totalPart = contentRange.substring(slashIndex + 1).trim();
        if ("*".equals(totalPart)) {
            return null;
        }
        try {
            return Long.parseLong(totalPart);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid total size in Content-Range header: " + contentRange, e);
        }
    }

    public String getSource() {
        return this.sourceUrl;
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.httpClient.dispatcher().executorService().shutdown();
            this.httpClient.connectionPool().evictAll();
        }
    }

    private void validateResponse(Response response, long requestedOffset, long requestedLength) throws IOException {
        if (response.code() == 206) {
            this.validateContentRange(response, requestedOffset, requestedLength);
        } else if (response.code() == 200) {
            this.validateFullContentResponse(response, requestedOffset, requestedLength);
        } else {
            if (response.code() == 416) {
                throw new IOException("Requested range not satisfiable: " + response.header("Content-Range"));
            }
            throw new IOException("HTTP request failed with status: " + response.code() + " " + response.message());
        }
    }

    private void validateContentRange(Response response, long requestedOffset, long requestedLength) throws IOException {
        String contentRange = response.header("Content-Range");
        if (contentRange == null) {
            throw new IOException("Server returned 206 but no Content-Range header");
        }
        if (!contentRange.startsWith("bytes ")) {
            throw new IOException("Invalid Content-Range header format: " + contentRange);
        }
        String rangeInfo = contentRange.substring("bytes ".length());
        String[] parts = rangeInfo.split("/");
        if (parts.length != 2) {
            throw new IOException("Invalid Content-Range header format: " + contentRange);
        }
        String[] rangeParts = parts[0].split("-");
        if (rangeParts.length != 2) {
            throw new IOException("Invalid Content-Range header format: " + contentRange);
        }
        long start = Long.parseLong(rangeParts[0]);
        long end = Long.parseLong(rangeParts[1]);
        if (start != requestedOffset) {
            throw new IOException("Server returned different start offset. Expected: " + requestedOffset + ", Got: " + start);
        }
        long expectedEnd = requestedOffset + requestedLength - 1L;
        if (end != expectedEnd) {
            throw new IOException("Server returned different end offset. Expected: " + expectedEnd + ", Got: " + end);
        }
    }

    private void validateFullContentResponse(Response response, long requestedOffset, long requestedLength) throws IOException {
        long totalSize;
        String contentLength = response.header("Content-Length");
        if (contentLength != null && requestedOffset + requestedLength > (totalSize = Long.parseLong(contentLength))) {
            throw new IOException("Requested range exceeds content size. Size: " + totalSize + ", Requested: " + requestedOffset + "-" + (requestedOffset + requestedLength - 1L));
        }
    }

    private void validateNotClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException("HttpByteRangeFetcher has been closed");
        }
    }
}

