/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.vectordata.transport;

import io.nosqlbench.nbdatatools.api.transport.StreamingFetchResult;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpStreamingFetchResult
implements StreamingFetchResult {
    private final Response response;
    private final ResponseBody responseBody;
    private final long offset;
    private final long requestedLength;
    private final String source;
    private final ReadableByteChannel channel;
    private volatile boolean closed = false;

    public HttpStreamingFetchResult(Response response, ResponseBody responseBody, long offset, long requestedLength, String source) {
        this.response = response;
        this.responseBody = responseBody;
        this.offset = offset;
        this.requestedLength = requestedLength;
        this.source = source;
        InputStream inputStream = responseBody.byteStream();
        this.channel = Channels.newChannel(inputStream);
    }

    public ReadableByteChannel getDataChannel() {
        if (this.closed) {
            throw new IllegalStateException("StreamingFetchResult has been closed");
        }
        return this.channel;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getRequestedLength() {
        return this.requestedLength;
    }

    public long getActualLength() {
        String contentRange;
        String contentLength = this.response.header("Content-Length");
        if (contentLength != null) {
            try {
                return Long.parseLong(contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((contentRange = this.response.header("Content-Range")) != null && contentRange.startsWith("bytes ")) {
            try {
                String[] rangeParts;
                String rangeInfo = contentRange.substring("bytes ".length());
                String[] parts = rangeInfo.split("/");
                if (parts.length == 2 && parts[0].contains("-") && (rangeParts = parts[0].split("-")).length == 2) {
                    long start = Long.parseLong(rangeParts[0]);
                    long end = Long.parseLong(rangeParts[1]);
                    return end - start + 1L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    public boolean isSuccessful() {
        return !this.closed && this.response.isSuccessful();
    }

    public String getSource() {
        return this.source;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.channel.close();
            }
            finally {
                try {
                    this.responseBody.close();
                }
                finally {
                    this.response.close();
                }
            }
        }
    }
}

