/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.vectordata.transport;

import io.nosqlbench.nbdatatools.api.services.TransportScheme;
import io.nosqlbench.nbdatatools.api.transport.ChunkedTransportClient;
import io.nosqlbench.nbdatatools.api.transport.ChunkedTransportProvider;
import io.nosqlbench.vectordata.transport.HttpByteRangeFetcher;
import java.io.IOException;
import java.net.URL;

@TransportScheme(value={"http", "https"})
public class HttpTransportProvider
implements ChunkedTransportProvider {
    public ChunkedTransportClient getClient(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        String scheme = url.getProtocol();
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            throw new UnsupportedOperationException("This provider only supports http/https URLs, got: " + scheme);
        }
        return new HttpByteRangeFetcher(url.toString());
    }
}

