/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.readers;

import io.nosqlbench.nbdatatools.api.fileio.ImmutableSizedReader;
import io.nosqlbench.nbdatatools.api.fileio.VectorFileArray;
import io.nosqlbench.nbdatatools.api.services.DataType;
import io.nosqlbench.nbdatatools.api.services.Encoding;
import io.nosqlbench.nbdatatools.api.services.FileExtension;
import io.nosqlbench.nbdatatools.api.services.FileType;
import io.nosqlbench.readers.ReaderUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

@Encoding(value=FileType.xvec)
@DataType(value=int[].class)
@FileExtension(value={".bvec", ".bvecs"})
public class UniformBvecReader
extends ImmutableSizedReader<int[]>
implements VectorFileArray<int[]> {
    private Path filePath;
    private int dimension;
    private int recordSize;
    private int size;
    private AsynchronousFileChannel fileChannel;

    public void open(Path filePath) {
        try {
            this.filePath = Objects.requireNonNull(filePath, "filePath cannot be null");
            this.fileChannel = AsynchronousFileChannel.open(filePath, StandardOpenOption.READ);
            ByteBuffer dimBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            final CompletableFuture readFuture = new CompletableFuture();
            this.fileChannel.read(dimBuffer, 0L, null, new CompletionHandler<Integer, Void>(){
                final /* synthetic */ UniformBvecReader this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void completed(Integer result, Void attachment) {
                    readFuture.complete(result);
                }

                @Override
                public void failed(Throwable exc, Void attachment) {
                    readFuture.completeExceptionally(exc);
                }
            });
            try {
                int bytesRead = (Integer)readFuture.get();
                if (bytesRead != 4) {
                    throw new IOException("Failed to read dimension from file: " + String.valueOf(filePath));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException("Failed to read dimension from file: " + String.valueOf(filePath), e);
            }
            dimBuffer.flip();
            this.dimension = dimBuffer.getInt();
            if (this.dimension <= 0) {
                throw new IOException("Invalid dimension in file: " + this.dimension);
            }
            this.recordSize = 4 + this.dimension * 4;
            try {
                long fileSize = this.fileChannel.size();
                this.size = ReaderUtils.computeVectorCount(this.filePath, fileSize, this.recordSize, 1);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int[] get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for size " + this.size);
        }
        try {
            int bytesRead;
            long offset = (long)index * (long)this.recordSize;
            long vectorDataOffset = offset + 4L;
            ByteBuffer buffer = ByteBuffer.allocate(this.dimension * 4).order(ByteOrder.LITTLE_ENDIAN);
            final CompletableFuture readFuture = new CompletableFuture();
            this.fileChannel.read(buffer, vectorDataOffset, null, new CompletionHandler<Integer, Void>(){
                final /* synthetic */ UniformBvecReader this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void completed(Integer bytesRead, Void attachment) {
                    readFuture.complete(bytesRead);
                }

                @Override
                public void failed(Throwable exc, Void attachment) {
                    readFuture.completeExceptionally(exc);
                }
            });
            try {
                bytesRead = (Integer)readFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException("Failed to read vector data at index " + index, e);
            }
            if (bytesRead != this.dimension * 4) {
                throw new IOException("Failed to read vector data at index " + index + ": expected " + this.dimension * 4 + " bytes, got " + bytesRead);
            }
            buffer.flip();
            int[] vector = new int[this.dimension];
            for (int i = 0; i < this.dimension; ++i) {
                vector[i] = buffer.getInt();
            }
            return vector;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading vector at index " + index, e);
        }
    }

    public void close() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.filePath.getFileName().toString();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        if (!(o instanceof int[])) {
            return false;
        }
        int[] array = (int[])o;
        if (array.length != this.dimension) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            int[] vector = this.get(i);
            if (!Arrays.equals(vector, array)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(Object o) {
        if (!(o instanceof int[]) || ((int[])o).length != this.dimension) {
            return -1;
        }
        int[] array = (int[])o;
        for (int i = 0; i < this.size; ++i) {
            int[] vector = this.get(i);
            if (!Arrays.equals(vector, array)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (!(o instanceof int[]) || ((int[])o).length != this.dimension) {
            return -1;
        }
        int[] array = (int[])o;
        for (int i = this.size - 1; i >= 0; --i) {
            int[] vector = this.get(i);
            if (!Arrays.equals(vector, array)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public <E> E[] toArray(E[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.toArray(), this.size, a.getClass());
        }
        System.arraycopy(this.toArray(), 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public List<int[]> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + ", size: " + this.size);
        }
        return new SublistBvecReader(this, fromIndex, toIndex);
    }

    public int getDimension() {
        return this.dimension;
    }

    private static class SublistBvecReader
    extends ImmutableSizedReader<int[]> {
        private final UniformBvecReader parent;
        private final int offset;
        private final int size;

        public SublistBvecReader(UniformBvecReader parent, int fromIndex, int toIndex) {
            this.parent = parent;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        public int[] get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return this.parent.get(this.offset + index);
        }

        public int size() {
            return this.size;
        }

        public int getSize() {
            return this.size;
        }

        public String getName() {
            return this.parent.getName() + "[" + this.offset + ":" + (this.offset + this.size) + "]";
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public boolean contains(Object o) {
            if (!(o instanceof int[])) {
                return false;
            }
            int[] array = (int[])o;
            if (array.length != this.parent.getDimension()) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                int[] vector = this.get(i);
                if (!Arrays.equals(vector, array)) continue;
                return true;
            }
            return false;
        }

        public int indexOf(Object o) {
            if (!(o instanceof int[]) || ((int[])o).length != this.parent.getDimension()) {
                return -1;
            }
            int[] array = (int[])o;
            for (int i = 0; i < this.size; ++i) {
                int[] vector = this.get(i);
                if (!Arrays.equals(vector, array)) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (!(o instanceof int[]) || ((int[])o).length != this.parent.getDimension()) {
                return -1;
            }
            int[] array = (int[])o;
            for (int i = this.size - 1; i >= 0; --i) {
                int[] vector = this.get(i);
                if (!Arrays.equals(vector, array)) continue;
                return i;
            }
            return -1;
        }

        public List<int[]> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + ", size: " + this.size);
            }
            return this.parent.subList(this.offset + fromIndex, this.offset + toIndex);
        }

        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        public Object[] toArray() {
            Object[] result = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                result[i] = this.get(i);
            }
            return result;
        }

        public <E> E[] toArray(E[] a) {
            if (a.length < this.size) {
                return Arrays.copyOf(this.toArray(), this.size, a.getClass());
            }
            System.arraycopy(this.toArray(), 0, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = null;
            }
            return a;
        }
    }
}

