/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet;

import io.nosqlbench.nbdatatools.api.fileio.BoundedVectorFileStream;
import io.nosqlbench.nbdatatools.api.iteration.ConvertingIterable;
import io.nosqlbench.nbdatatools.api.iteration.FlatteningIterable;
import io.nosqlbench.nbdatatools.api.services.DataType;
import io.nosqlbench.nbdatatools.api.services.Encoding;
import io.nosqlbench.nbdatatools.api.services.FileType;
import io.nosqlbench.nbvectors.datasource.parquet.conversion.ConverterType;
import io.nosqlbench.nbvectors.datasource.parquet.traversal.ParquetGroupIterable;
import io.nosqlbench.nbvectors.datasource.parquet.traversal.RecordReaderIterable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.parquet.example.data.Group;

@Encoding(value=FileType.parquet)
@DataType(value=float[].class)
public class ParquetVectorStreamer
implements BoundedVectorFileStream<float[]> {
    private Iterable<float[]> compositeIterable;
    private List<Path> paths;
    private long size;
    private String converterType = "EMBEDDINGS_LIST_FLOAT";

    public ParquetVectorStreamer() {
    }

    public ParquetVectorStreamer(String converterType) {
        this.converterType = converterType;
    }

    private Function<Group, float[]> getConverter() {
        try {
            return ConverterType.createConverter(this.converterType);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void open(Path path) {
        this.open(List.of(path));
    }

    public void open(Path path, String converterType) {
        this.converterType = converterType;
        this.open(List.of(path));
    }

    public void open(List<Path> paths) {
        this.paths = paths;
        for (Path file : paths) {
            if (Files.isRegularFile(file, new LinkOption[0]) || Files.isSymbolicLink(file)) continue;
            throw new RuntimeException("unhandled file type for '" + String.valueOf(file) + "', only regular files and symlinks are allowed here");
        }
        FlatteningIterable recordReaderIterable = new FlatteningIterable(paths, RecordReaderIterable::new);
        FlatteningIterable groupIterable = new FlatteningIterable((Iterable)recordReaderIterable, ParquetGroupIterable::new);
        Function<Group, float[]> embeddingDecoder = this.getConverter();
        this.compositeIterable = new ConvertingIterable((Iterable)groupIterable, embeddingDecoder);
    }

    public void open(List<Path> paths, String converterType) {
        this.converterType = converterType;
        this.open(paths);
    }

    public static ParquetVectorStreamer of(List<Path> paths) {
        ParquetVectorStreamer reader = new ParquetVectorStreamer();
        reader.open(paths);
        return reader;
    }

    public static ParquetVectorStreamer of(List<Path> paths, String converterType) {
        ParquetVectorStreamer reader = new ParquetVectorStreamer(converterType);
        reader.open(paths);
        return reader;
    }

    public Iterator<float[]> iterator() {
        return this.compositeIterable.iterator();
    }

    public int getSize() {
        return -1;
    }

    public String getName() {
        return "parquet";
    }

    public void close() {
        if (this.compositeIterable instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.compositeIterable)).close();
            }
            catch (Exception e) {
                System.err.println("Error closing composite iterable: " + e.getMessage());
            }
        }
    }
}

