/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet.conversion;

import io.nosqlbench.nbvectors.datasource.parquet.conversion.EmbeddingsListFloat;
import io.nosqlbench.nbvectors.datasource.parquet.conversion.HFEmbedToFloatAry;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.parquet.example.data.Group;

public enum ConverterType {
    HFEMBED(new HFEmbedToFloatAry()),
    EMBEDDINGS_LIST_FLOAT(new EmbeddingsListFloat());

    private final Function<Group, float[]> converter;

    private ConverterType(Function<Group, float[]> converter) {
        this.converter = converter;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    private Function<Group, float[]> getConverter() {
        return this.converter;
    }

    private static ConverterType fromString(String name) {
        for (ConverterType type : ConverterType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown converter type: " + name + ". Available types: " + Arrays.toString((Object[])ConverterType.values()));
    }

    public static Function<Group, float[]> createConverter(String name) {
        return ConverterType.fromString(name).getConverter();
    }
}

