/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet.traversal;

import io.nosqlbench.nbdatatools.api.fileio.BoundedVectorFileStream;
import io.nosqlbench.nbdatatools.api.iteration.FlatteningIterable;
import io.nosqlbench.nbdatatools.api.services.DataType;
import io.nosqlbench.nbdatatools.api.services.Encoding;
import io.nosqlbench.nbdatatools.api.services.FileType;
import io.nosqlbench.nbvectors.datasource.parquet.ParquetVectorStreamer;
import io.nosqlbench.nbvectors.datasource.parquet.layout.PathBinning;
import io.nosqlbench.nbvectors.datasource.parquet.layout.PathsSorter;
import io.nosqlbench.nbvectors.datasource.parquet.traversal.ParquetScanResult;
import io.nosqlbench.nbvectors.datasource.parquet.traversal.ParquetTabulator;
import io.nosqlbench.nbvectors.datasource.parquet.traversal.functional.ParquetTraversal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Encoding(value=FileType.parquet)
@DataType(value=float[].class)
public class ParquetFloatDataAdapter
implements BoundedVectorFileStream<float[]> {
    private List<Path> paths;
    private Iterable<ParquetVectorStreamer> parquetVectorsReaders;
    private Iterable<float[]> iterable;
    private Path mainPath;
    private ParquetScanResult scanResult;

    public void open(Path path) {
        this.mainPath = path;
        this.open(List.of(this.mainPath));
    }

    private void open(List<Path> paths) {
        this.paths = paths;
        this.scanResult = null;
        this.parquetVectorsReaders = this.composeAggregatorsIterable();
        this.iterable = new FlatteningIterable(this.parquetVectorsReaders, f -> f);
    }

    private ParquetScanResult prescanParquetFiles(List<Path> paths) {
        ParquetTabulator tabulator = new ParquetTabulator();
        ParquetTraversal traversal = new ParquetTraversal(paths, 10);
        traversal.traverse(tabulator);
        long totalRecords = tabulator.getRecordCount();
        return new ParquetScanResult(totalRecords);
    }

    public Iterable<ParquetVectorStreamer> composeAggregatorsIterable() {
        int dirs = 0;
        int files = 0;
        for (Path path : this.paths) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                ++dirs;
                continue;
            }
            if (Files.isRegularFile(path, new LinkOption[0]) || Files.isSymbolicLink(path)) {
                ++files;
                continue;
            }
            throw new RuntimeException("unhandled file type for '" + String.valueOf(path) + "'");
        }
        if (dirs != 0 && files != 0) {
            throw new RuntimeException("unable to handle mixed dirs (" + dirs + ") and files (" + files + "). Either pass dirs which represent groupings, or files which represent the contents of a single grouping.");
        }
        if (files > 0) {
            return List.of(ParquetVectorStreamer.of(this.paths));
        }
        PathBinning binning = new PathBinning(this.paths);
        PathBinning.BinningResult bins = binning.getBins();
        Map<Path, List<Path>> parentGroups = bins.toParentGroups();
        PathsSorter sorter = new PathsSorter(parentGroups.keySet(), true);
        PathsSorter.SortedResults sorted = sorter.sorted(PathsSorter.BY_REVERSE_TOTAL_SIZE, PathsSorter.BY_NAME);
        System.out.println("sorted:\n");
        sorted.forEach(s -> System.out.println(s.getRootPath()));
        return sorted.stream().map(a -> ParquetVectorStreamer.of(a.getFileList().stream().sorted().collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public Iterator<float[]> iterator() {
        return this.iterable.iterator();
    }

    public int getSize() {
        if (this.scanResult == null) {
            return -1;
        }
        return this.scanResult.getTotalRecordsAsInt();
    }

    public String getName() {
        return this.mainPath != null ? this.mainPath.toString() : this.getClass().getCanonicalName() + ":NOPATH";
    }
}

