/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet.traversal;

import io.nosqlbench.nbvectors.datasource.parquet.traversal.functional.BoundedRecordReader;
import java.util.Iterator;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.io.RecordReader;

public class ParquetGroupIterable
implements Iterable<Group> {
    private final BoundedRecordReader<Group> recordReader;

    public ParquetGroupIterable(BoundedRecordReader<Group> recordReader) {
        this.recordReader = recordReader;
    }

    @Override
    public Iterator<Group> iterator() {
        return new ParquetGroupIterator(this.recordReader);
    }

    private class ParquetGroupIterator
    implements Iterator<Group> {
        private final RecordReader<Group> groupReader;
        private final long count;
        private long remaining;

        public ParquetGroupIterator(BoundedRecordReader<Group> groupReader) {
            this.groupReader = groupReader.reader();
            this.remaining = this.count = groupReader.count();
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0L;
        }

        @Override
        public Group next() {
            --this.remaining;
            return (Group)this.groupReader.read();
        }
    }
}

