/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet.traversal;

import java.util.Objects;

public class ParquetScanResult {
    private final long totalRecords;

    public ParquetScanResult(long totalRecords) {
        if (totalRecords < 0L) {
            throw new IllegalArgumentException("Total records cannot be negative: " + totalRecords);
        }
        this.totalRecords = totalRecords;
    }

    public long totalRecords() {
        return this.totalRecords;
    }

    public int getTotalRecordsAsInt() {
        if (this.totalRecords > Integer.MAX_VALUE) {
            throw new RuntimeException("int overflow on long size: " + this.totalRecords);
        }
        return (int)this.totalRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParquetScanResult that = (ParquetScanResult)o;
        return this.totalRecords == that.totalRecords;
    }

    public int hashCode() {
        return Objects.hash(this.totalRecords);
    }

    public String toString() {
        return "ParquetScanResult{totalRecords=" + this.totalRecords + "}";
    }
}

