/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet.traversal;

import io.nosqlbench.nbvectors.datasource.parquet.layout.PathAggregator;
import io.nosqlbench.nbvectors.datasource.parquet.traversal.functional.BoundedPageStore;
import io.nosqlbench.nbvectors.datasource.parquet.traversal.functional.ParquetVisitor;

public class ParquetTabulator
implements ParquetVisitor {
    private long totalRows = Long.MIN_VALUE;

    public long getRecordCount() {
        if (this.totalRows == Long.MIN_VALUE) {
            throw new RuntimeException("Unable to get count without traversal first.");
        }
        return this.totalRows;
    }

    @Override
    public synchronized void beforeAll() {
        this.totalRows = 0L;
    }

    @Override
    public ParquetVisitor.Depth getTraversalDepth() {
        return ParquetVisitor.Depth.PAGES;
    }

    @Override
    public synchronized void afterPage(BoundedPageStore pageStore) {
        long rowCount = pageStore.pageReadStore().getRowCount();
        this.totalRows += rowCount;
    }

    @Override
    public synchronized void afterRoot(PathAggregator path) {
        System.out.println("row count up to " + this.totalRows + " for " + String.valueOf(path.getRootPath().getFileName()));
    }
}

