/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet.traversal;

import io.nosqlbench.nbvectors.datasource.parquet.traversal.functional.BoundedRecordReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.LocalInputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

public class RecordReaderIterable
implements Iterable<BoundedRecordReader<Group>>,
AutoCloseable {
    private final Path path;
    private RecordReaderIterator currentIterator;

    public RecordReaderIterable(Path path) {
        this.path = path;
    }

    @Override
    public Iterator<BoundedRecordReader<Group>> iterator() {
        if (this.currentIterator != null) {
            try {
                this.currentIterator.close();
            }
            catch (Exception e) {
                System.err.println("Error closing previous iterator: " + e.getMessage());
            }
        }
        this.currentIterator = new RecordReaderIterator(this.path);
        return this.currentIterator;
    }

    @Override
    public void close() throws Exception {
        if (this.currentIterator != null) {
            this.currentIterator.close();
            this.currentIterator = null;
        }
    }

    private class RecordReaderIterator
    implements Iterator<BoundedRecordReader<Group>>,
    AutoCloseable {
        public final ParquetFileReader fileReader;
        public final MessageColumnIO columnIO;
        private final MessageType schema;
        private PageReadStore pageReadStore;
        private boolean closed = false;

        public RecordReaderIterator(Path path) {
            LocalInputFile inf = new LocalInputFile(path);
            System.err.println("reading path: " + String.valueOf(path));
            try {
                this.fileReader = ParquetFileReader.open((InputFile)inf);
                ParquetMetadata footer = this.fileReader.getFooter();
                this.schema = footer.getFileMetaData().getSchema();
                this.columnIO = new ColumnIOFactory().getColumnIO(this.schema);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws Exception {
            if (!this.closed) {
                this.fileReader.close();
                this.closed = true;
            }
        }

        @Override
        public boolean hasNext() {
            this.readIfEmpty();
            return this.pageReadStore != null;
        }

        private void readIfEmpty() {
            if (this.pageReadStore == null) {
                try {
                    this.pageReadStore = this.fileReader.readNextRowGroup();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public BoundedRecordReader<Group> next() {
            this.readIfEmpty();
            long rowCount = this.pageReadStore.getRowCount();
            RecordReader recordReader = this.columnIO.getRecordReader(this.pageReadStore, (RecordMaterializer)new GroupRecordConverter(this.schema));
            this.pageReadStore = null;
            return new BoundedRecordReader<Group>(recordReader, rowCount);
        }
    }
}

