/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.vectordata.transport;

import io.nosqlbench.nbdatatools.api.services.TransportScheme;
import io.nosqlbench.nbdatatools.api.transport.ChunkedTransportClient;
import io.nosqlbench.nbdatatools.api.transport.FetchResult;
import io.nosqlbench.nbdatatools.api.transport.StreamingFetchResult;
import io.nosqlbench.vectordata.transport.FileStreamingFetchResult;
import io.nosqlbench.vectordata.transport.LimitedReadableByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@TransportScheme(value={"file"})
public class FileByteRangeFetcher
implements ChunkedTransportClient {
    private final Path filePath;
    private final AsynchronousFileChannel asyncChannel;
    private final AtomicReference<Long> cachedSize = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public FileByteRangeFetcher(Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException("File does not exist: " + String.valueOf(path));
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IOException("Path is not a regular file: " + String.valueOf(path));
        }
        if (!Files.isReadable(path)) {
            throw new IOException("File is not readable: " + String.valueOf(path));
        }
        this.filePath = path;
        try {
            this.asyncChannel = AsynchronousFileChannel.open(path, StandardOpenOption.READ);
            this.cachedSize.set(Files.size(path));
        }
        catch (IOException e) {
            throw new IOException("Failed to open file: " + String.valueOf(path), e);
        }
    }

    public CompletableFuture<? extends FetchResult<?>> fetchRange(long offset, long length) throws IOException {
        this.validateNotClosed();
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset cannot be negative: " + offset);
        }
        if (length <= 0L) {
            throw new IllegalArgumentException("Length must be positive: " + length);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                long fileSize = this.cachedSize.get();
                if (offset >= fileSize) {
                    throw new RuntimeException("Offset " + offset + " is beyond file size " + fileSize);
                }
                long availableBytes = fileSize - offset;
                long actualLength = Math.min(length, availableBytes);
                if (actualLength > Integer.MAX_VALUE) {
                    throw new RuntimeException("Chunk size exceeds 2GB limit for ByteBuffer: " + actualLength + " bytes. Use streaming methods (fetchRangeStreaming) for chunks larger than 2GB.");
                }
                ByteBuffer data = actualLength <= 8192L ? this.readWithAsyncChannel(offset, actualLength) : this.readWithMemoryMapping(offset, actualLength);
                return new FetchResult(data, offset, length);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to fetch range (FileByteRangeFetcher) [" + offset + "-" + (offset + length - 1L) + "]", e);
            }
        });
    }

    public CompletableFuture<StreamingFetchResult> fetchRangeStreaming(long offset, long length) throws IOException {
        this.validateNotClosed();
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset cannot be negative: " + offset);
        }
        if (length <= 0L) {
            throw new IllegalArgumentException("Length must be positive: " + length);
        }
        long fileSize = this.cachedSize.get();
        if (offset >= fileSize) {
            throw new IllegalArgumentException("Offset " + offset + " exceeds file size " + fileSize);
        }
        long actualLength = Math.min(length, fileSize - offset);
        return CompletableFuture.supplyAsync(() -> {
            try {
                FileChannel channel = FileChannel.open(this.filePath, StandardOpenOption.READ);
                channel.position(offset);
                LimitedReadableByteChannel limitedChannel = new LimitedReadableByteChannel(channel, actualLength);
                return new FileStreamingFetchResult(channel, limitedChannel, offset, length, actualLength, this.getSource());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create streaming channel for range [" + offset + "-" + (offset + length - 1L) + "]", e);
            }
        });
    }

    public CompletableFuture<Long> getSize() throws IOException {
        this.validateNotClosed();
        Long size = this.cachedSize.get();
        return CompletableFuture.completedFuture(size);
    }

    public boolean supportsRangeRequests() {
        return true;
    }

    public String getSource() {
        return this.filePath.toUri().toString();
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.asyncChannel.close();
            }
            catch (IOException e) {
                throw new IOException("Failed to close file channel for: " + String.valueOf(this.filePath), e);
            }
        }
    }

    private ByteBuffer readWithAsyncChannel(long offset, long length) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate((int)length);
        try {
            int bytesRead = this.asyncChannel.read(buffer, offset).get();
            if (bytesRead != (int)length) {
                throw new IOException("Expected to read " + length + " bytes but read " + bytesRead);
            }
            buffer.flip();
            return buffer;
        }
        catch (Exception e) {
            throw new IOException("Failed to read from async channel", e);
        }
    }

    private ByteBuffer readWithMemoryMapping(long offset, long length) throws IOException {
        ByteBuffer byteBuffer;
        block8: {
            FileChannel fileChannel = FileChannel.open(this.filePath, StandardOpenOption.READ);
            try {
                MappedByteBuffer mappedBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, offset, length);
                ByteBuffer result = ByteBuffer.allocate((int)length);
                result.put(mappedBuffer);
                result.flip();
                byteBuffer = result;
                if (fileChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Failed to memory map file region", e);
                }
            }
            fileChannel.close();
        }
        return byteBuffer;
    }

    private void validateNotClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException("FileByteRangeFetcher has been closed");
        }
    }
}

