/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.vectordata.transport;

import io.nosqlbench.nbdatatools.api.transport.StreamingFetchResult;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

public class FileStreamingFetchResult
implements StreamingFetchResult {
    private final FileChannel fileChannel;
    private final ReadableByteChannel limitedChannel;
    private final long offset;
    private final long requestedLength;
    private final long actualLength;
    private final String source;
    private volatile boolean closed = false;

    public FileStreamingFetchResult(FileChannel fileChannel, ReadableByteChannel limitedChannel, long offset, long requestedLength, long actualLength, String source) {
        this.fileChannel = fileChannel;
        this.limitedChannel = limitedChannel;
        this.offset = offset;
        this.requestedLength = requestedLength;
        this.actualLength = actualLength;
        this.source = source;
    }

    public ReadableByteChannel getDataChannel() {
        if (this.closed) {
            throw new IllegalStateException("StreamingFetchResult has been closed");
        }
        return this.limitedChannel;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getRequestedLength() {
        return this.requestedLength;
    }

    public long getActualLength() {
        return this.actualLength;
    }

    public boolean isSuccessful() {
        return !this.closed && this.fileChannel.isOpen();
    }

    public String getSource() {
        return this.source;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.fileChannel.close();
        }
    }
}

