/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.vectordata.transport;

import io.nosqlbench.nbdatatools.api.services.TransportScheme;
import io.nosqlbench.nbdatatools.api.transport.ChunkedTransportClient;
import io.nosqlbench.nbdatatools.api.transport.ChunkedTransportProvider;
import io.nosqlbench.vectordata.transport.FileByteRangeFetcher;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

@TransportScheme(value={"file"})
public class FileTransportProvider
implements ChunkedTransportProvider {
    public ChunkedTransportClient getClient(URL url) throws IOException {
        Path path;
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        String scheme = url.getProtocol();
        if (!"file".equalsIgnoreCase(scheme)) {
            throw new UnsupportedOperationException("This provider only supports file:// URLs, got: " + scheme);
        }
        try {
            path = Paths.get(url.toURI());
        }
        catch (Exception e) {
            throw new IOException("Failed to convert URL to path: " + String.valueOf(url), e);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException("File does not exist: " + String.valueOf(path));
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IOException("Path is not a regular file: " + String.valueOf(path));
        }
        if (!Files.isReadable(path)) {
            throw new IOException("File is not readable: " + String.valueOf(path));
        }
        return new FileByteRangeFetcher(path);
    }
}

