/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.vectordata.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class LimitedReadableByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel delegate;
    private final long limit;
    private long bytesRead = 0L;
    private boolean open = true;

    public LimitedReadableByteChannel(ReadableByteChannel delegate, long limit) {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate channel cannot be null");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit cannot be negative");
        }
        this.delegate = delegate;
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.open) {
            throw new IOException("Channel is closed");
        }
        if (this.bytesRead >= this.limit) {
            return -1;
        }
        long remaining = this.limit - this.bytesRead;
        if (remaining == 0L) {
            return -1;
        }
        int originalLimit = dst.limit();
        if (remaining < (long)dst.remaining()) {
            if (remaining > Integer.MAX_VALUE) {
                dst.limit(dst.position() + Math.min(dst.remaining(), Integer.MAX_VALUE));
            } else {
                dst.limit(dst.position() + (int)remaining);
            }
        }
        try {
            int bytesReadNow = this.delegate.read(dst);
            if (bytesReadNow > 0) {
                this.bytesRead += (long)bytesReadNow;
            }
            int n = bytesReadNow;
            return n;
        }
        finally {
            dst.limit(originalLimit);
        }
    }

    @Override
    public boolean isOpen() {
        return this.open && this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesRemaining() {
        return Math.max(0L, this.limit - this.bytesRead);
    }
}

