/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.readers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.nosqlbench.nbdatatools.api.fileio.VectorFileStream;
import io.nosqlbench.nbdatatools.api.services.DataType;
import io.nosqlbench.nbdatatools.api.services.Encoding;
import io.nosqlbench.nbdatatools.api.services.FileExtension;
import io.nosqlbench.nbdatatools.api.services.FileType;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

@Encoding(value=FileType.csv)
@DataType(value=float[].class)
@FileExtension(value={".csv"})
public class CsvJsonArrayStreamer
implements VectorFileStream<float[]> {
    private Path filePath;
    private int vectorColumn = -1;
    private boolean firstLineIsData = false;
    private static final Pattern JSON_ARRAY_PATTERN = Pattern.compile("\\s*\\[\\s*[\\d.-]+.*\\]\\s*");

    public CsvJsonArrayStreamer() {
    }

    public CsvJsonArrayStreamer(Path path) {
        this.open(path);
    }

    private void initialize() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.filePath.toFile()));){
            String firstLine = reader.readLine();
            if (firstLine == null) {
                throw new IOException("Empty CSV file: " + String.valueOf(this.filePath));
            }
            String secondLine = reader.readLine();
            if (secondLine == null) {
                String[] fields = this.parseCsvLine(firstLine);
                this.findVectorColumn(fields);
                this.firstLineIsData = true;
                return;
            }
            String[] firstLineFields = this.parseCsvLine(firstLine);
            String[] secondLineFields = this.parseCsvLine(secondLine);
            boolean firstLineHasVectorArray = false;
            boolean secondLineHasVectorArray = false;
            for (String field : firstLineFields) {
                if (!JSON_ARRAY_PATTERN.matcher(field.trim()).matches() || !this.isJsonNumberArray(field.trim())) continue;
                firstLineHasVectorArray = true;
                break;
            }
            for (String field : secondLineFields) {
                if (!JSON_ARRAY_PATTERN.matcher(field.trim()).matches() || !this.isJsonNumberArray(field.trim())) continue;
                secondLineHasVectorArray = true;
                break;
            }
            if (!firstLineHasVectorArray && secondLineHasVectorArray) {
                this.firstLineIsData = false;
                this.findVectorColumnInLine(secondLineFields);
            } else if (firstLineHasVectorArray == secondLineHasVectorArray) {
                boolean structuralDifference = this.detectStructuralDifference(firstLineFields, secondLineFields);
                if (structuralDifference) {
                    this.firstLineIsData = false;
                    this.findVectorColumnInLine(secondLineFields);
                } else {
                    this.firstLineIsData = true;
                    this.findVectorColumnInLine(firstLineFields);
                }
            } else {
                this.firstLineIsData = true;
                this.findVectorColumnInLine(firstLineFields);
            }
            if (this.vectorColumn == -1) {
                throw new IOException("No JSON array column found in CSV file: " + String.valueOf(this.filePath));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize CSV JSON array streamer", e);
        }
    }

    private boolean detectStructuralDifference(String[] firstRow, String[] secondRow) {
        if (firstRow.length != secondRow.length) {
            return true;
        }
        int diffCount = 0;
        for (int i = 0; i < Math.min(firstRow.length, secondRow.length); ++i) {
            boolean field2HasArray;
            boolean field1HasArray;
            boolean field2IsLikelyHeader;
            String field1 = firstRow[i].trim();
            String field2 = secondRow[i].trim();
            boolean field1IsLikelyHeader = this.isLikelyHeaderField(field1);
            if (field1IsLikelyHeader != (field2IsLikelyHeader = this.isLikelyHeaderField(field2))) {
                ++diffCount;
            }
            if ((field1HasArray = JSON_ARRAY_PATTERN.matcher(field1).matches()) == (field2HasArray = JSON_ARRAY_PATTERN.matcher(field2).matches())) continue;
            diffCount += 2;
        }
        return diffCount >= Math.max(1, firstRow.length / 3);
    }

    private boolean isLikelyHeaderField(String field) {
        if (field.length() < 20 && !field.contains(" ") && !field.matches(".*\\d{2,}.*")) {
            String lowerField = field.toLowerCase();
            return lowerField.matches("^[a-z_]+$") || lowerField.equals("id") || lowerField.contains("name") || lowerField.contains("label") || lowerField.contains("vector") || lowerField.contains("desc");
        }
        return false;
    }

    private void findVectorColumnInLine(String[] fields) throws IOException {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i].trim();
            if (!JSON_ARRAY_PATTERN.matcher(field).matches() || !this.isJsonNumberArray(field)) continue;
            if (this.vectorColumn != -1) {
                throw new IOException("Multiple JSON array columns found in CSV file. Only one is supported.");
            }
            this.vectorColumn = i;
        }
    }

    private void findVectorColumn(String[] fields) throws IOException {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i].trim();
            if (!JSON_ARRAY_PATTERN.matcher(field).matches() || !this.isJsonNumberArray(field)) continue;
            if (this.vectorColumn != -1) {
                throw new IOException("Multiple JSON array columns found in CSV file. Only one is supported.");
            }
            this.vectorColumn = i;
        }
    }

    private boolean isJsonNumberArray(String jsonStr) {
        try {
            JsonElement element = JsonParser.parseString((String)jsonStr);
            if (!element.isJsonArray()) {
                return false;
            }
            JsonArray array = element.getAsJsonArray();
            for (JsonElement item : array) {
                if (item.isJsonPrimitive() && item.getAsJsonPrimitive().isNumber()) continue;
                return false;
            }
            return array.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String[] parseCsvLine(String line) {
        ArrayList<String> fields = new ArrayList<String>();
        boolean inQuotes = false;
        StringBuilder currentField = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ',' && !inQuotes) {
                fields.add(currentField.toString());
                currentField = new StringBuilder();
                continue;
            }
            currentField.append(c);
        }
        fields.add(currentField.toString());
        return fields.toArray(new String[0]);
    }

    private float[] parseJsonFloatArray(String jsonArrayStr) {
        try {
            JsonArray jsonArray = JsonParser.parseString((String)jsonArrayStr).getAsJsonArray();
            float[] result = new float[jsonArray.size()];
            for (int i = 0; i < jsonArray.size(); ++i) {
                result[i] = jsonArray.get(i).getAsFloat();
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse JSON array: " + jsonArrayStr, e);
        }
    }

    public String getName() {
        return "CsvJsonArray(" + this.filePath.getFileName().toString() + ")";
    }

    public Iterator<float[]> iterator() {
        return new CsvStreamIterator();
    }

    public void open(Path path) {
        this.filePath = path;
        this.initialize();
    }

    private class CsvStreamIterator
    implements Iterator<float[]> {
        private BufferedReader reader;
        private String nextLine;
        private boolean initialized = false;

        public CsvStreamIterator() {
            try {
                this.reader = new BufferedReader(new FileReader(CsvJsonArrayStreamer.this.filePath.toFile()));
                if (!CsvJsonArrayStreamer.this.firstLineIsData) {
                    this.reader.readLine();
                }
                this.advance();
                this.initialized = true;
            }
            catch (IOException e) {
                this.close();
                throw new RuntimeException("Failed to initialize CSV iterator", e);
            }
        }

        private void advance() {
            try {
                this.nextLine = this.reader.readLine();
                while (this.nextLine != null) {
                    String jsonArrayStr;
                    String[] fields = CsvJsonArrayStreamer.this.parseCsvLine(this.nextLine);
                    if (fields.length > CsvJsonArrayStreamer.this.vectorColumn && JSON_ARRAY_PATTERN.matcher(jsonArrayStr = fields[CsvJsonArrayStreamer.this.vectorColumn].trim()).matches()) {
                        try {
                            CsvJsonArrayStreamer.this.parseJsonFloatArray(jsonArrayStr);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.nextLine = this.reader.readLine();
                }
            }
            catch (IOException e) {
                this.close();
                throw new RuntimeException("Error reading from CSV file", e);
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                throw new IllegalStateException("Iterator not initialized");
            }
            return this.nextLine != null;
        }

        @Override
        public float[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String[] fields = CsvJsonArrayStreamer.this.parseCsvLine(this.nextLine);
            String jsonArrayStr = fields[CsvJsonArrayStreamer.this.vectorColumn].trim();
            float[] vector = CsvJsonArrayStreamer.this.parseJsonFloatArray(jsonArrayStr);
            this.advance();
            return vector;
        }

        private void close() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

