/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.readers;

import io.nosqlbench.nbdatatools.api.fileio.BoundedVectorFileStream;
import io.nosqlbench.nbdatatools.api.services.DataType;
import io.nosqlbench.nbdatatools.api.services.Encoding;
import io.nosqlbench.nbdatatools.api.services.FileExtension;
import io.nosqlbench.nbdatatools.api.services.FileType;
import io.nosqlbench.readers.ReaderUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

@DataType(value=double[].class)
@Encoding(value=FileType.xvec)
@FileExtension(value={".dvec", ".dvecs"})
public class UniformDvecStreamer
implements BoundedVectorFileStream<double[]> {
    private Path filePath;
    private int dimension;
    private int recordSize;
    private int size;
    private AsynchronousFileChannel fileChannel;

    public void open(Path filePath) {
        try {
            this.filePath = Objects.requireNonNull(filePath, "filePath cannot be null");
            this.fileChannel = AsynchronousFileChannel.open(filePath, StandardOpenOption.READ);
            ByteBuffer dimBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            final CompletableFuture readFuture = new CompletableFuture();
            this.fileChannel.read(dimBuffer, 0L, null, new CompletionHandler<Integer, Void>(){
                final /* synthetic */ UniformDvecStreamer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void completed(Integer result, Void attachment) {
                    readFuture.complete(result);
                }

                @Override
                public void failed(Throwable exc, Void attachment) {
                    readFuture.completeExceptionally(exc);
                }
            });
            try {
                int bytesRead = (Integer)readFuture.get();
                if (bytesRead != 4) {
                    throw new IOException("Failed to read dimension from file: " + String.valueOf(filePath));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException("Failed to read dimension from file: " + String.valueOf(filePath), e);
            }
            dimBuffer.flip();
            this.dimension = dimBuffer.getInt();
            if (this.dimension <= 0) {
                throw new IOException("Invalid dimension in file: " + this.dimension);
            }
            this.recordSize = 4 + this.dimension * 8;
            try {
                long fileSize = this.fileChannel.size();
                this.size = ReaderUtils.computeVectorCount(this.filePath, fileSize, this.recordSize, 8);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double[] readVector(int index) throws IOException {
        int bytesRead;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for size " + this.size);
        }
        long offset = (long)index * (long)this.recordSize;
        long vectorDataOffset = offset + 4L;
        ByteBuffer buffer = ByteBuffer.allocate(this.dimension * 8).order(ByteOrder.LITTLE_ENDIAN);
        final CompletableFuture readFuture = new CompletableFuture();
        this.fileChannel.read(buffer, vectorDataOffset, null, new CompletionHandler<Integer, Void>(){
            final /* synthetic */ UniformDvecStreamer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void completed(Integer bytesRead, Void attachment) {
                readFuture.complete(bytesRead);
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                readFuture.completeExceptionally(exc);
            }
        });
        try {
            bytesRead = (Integer)readFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to read vector data at index " + index, e);
        }
        if (bytesRead != this.dimension * 8) {
            throw new IOException("Failed to read vector data at index " + index + ": expected " + this.dimension * 8 + " bytes, got " + bytesRead);
        }
        buffer.flip();
        double[] vector = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            vector[i] = buffer.getDouble();
        }
        return vector;
    }

    public void close() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.filePath.getFileName().toString();
    }

    public Iterator<double[]> iterator() {
        return new Iterator<double[]>(){
            private int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < UniformDvecStreamer.this.size;
            }

            @Override
            public double[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    return UniformDvecStreamer.this.readVector(this.currentIndex++);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading vector at index " + (this.currentIndex - 1), e);
                }
            }
        };
    }
}

