/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.xvec.writers;

import io.nosqlbench.nbdatatools.api.fileio.VectorFileStreamStore;
import io.nosqlbench.nbdatatools.api.services.DataType;
import io.nosqlbench.nbdatatools.api.services.Encoding;
import io.nosqlbench.nbdatatools.api.services.FileExtension;
import io.nosqlbench.nbdatatools.api.services.FileType;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;

@DataType(value=int[].class)
@Encoding(value=FileType.xvec)
@FileExtension(value={".ivec", ".ivecs"})
public class IvecVectorWriter
implements VectorFileStreamStore<int[]> {
    private BufferedOutputStream outputStream;
    private Integer dimension;
    private ByteBuffer buffer;

    public void open(Path path) {
        try {
            this.outputStream = new BufferedOutputStream(new FileOutputStream(path.toFile()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open file for writing: " + String.valueOf(path), e);
        }
    }

    public void flush() {
    }

    public void write(int[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (this.dimension == null) {
            this.dimension = data.length;
        } else if (this.dimension != data.length) {
            throw new IllegalArgumentException("Vector dimension mismatch. Expected: " + this.dimension + ", Got: " + data.length);
        }
        try {
            if (this.buffer == null || this.buffer.capacity() < (this.dimension + 1) * 4) {
                this.buffer = ByteBuffer.allocate((this.dimension + 1) * 4).order(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.buffer.clear();
            }
            this.buffer.putInt(this.dimension);
            for (int value : data) {
                this.buffer.putInt(value);
            }
            this.buffer.flip();
            this.outputStream.write(this.buffer.array(), 0, this.buffer.limit());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write vector data", e);
        }
    }

    public void close() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close output stream", e);
            }
        }
    }
}

