/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.buildhdf5;

import io.nosqlbench.nbvectors.buildhdf5.JJQSupplier;
import io.nosqlbench.nbvectors.buildhdf5.JsonLoader;
import io.nosqlbench.nbvectors.buildhdf5.KnnDataWriter;
import io.nosqlbench.nbvectors.buildhdf5.MapperConfig;
import io.nosqlbench.nbvectors.jjq.evaluator.JJQInvoker;
import io.nosqlbench.nbvectors.jjq.outputs.BufferOutput;
import io.nosqlbench.nbvectors.verifyknn.logging.CustomConfigurationFactory;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="buildhdf5", headerHeading="Usage:%n%n", synopsisHeading="%n", descriptionHeading="%nDescription%n%n", parameterListHeading="%nParameters:%n%", optionListHeading="%nOptions:%n", header={"build HDF5 KNN test data answer-keys from JSON"}, description={"TBD\n"}, exitCodeListHeading="Exit Codes:%n", exitCodeList={"0: no errors"})
public class CMD_BuildHDF5
implements Callable<Integer> {
    private static final Logger logger = LogManager.getLogger(CMD_BuildHDF5.class);
    @CommandLine.Option(names={"-o", "--outfile"}, required=true, defaultValue="out.hdf5", description={"The HDF5 file to write"})
    private Path hdfOutPath;
    @CommandLine.Option(names={"-l", "--layout"}, required=true, defaultValue="layout.yaml", description={"The yaml file containing the layout instructions."})
    private Path layoutPath;

    @CommandLine.Option(names={"--_diaglevel", "-_d"}, hidden=true, description={"Internal diagnostic level, sends content directly to the console."}, defaultValue="ERROR")
    public static void main(String[] args) {
        System.setProperty("slf4j.internal.verbosity", "ERROR");
        System.setProperty("log4j.configurationFactory", CustomConfigurationFactory.class.getCanonicalName());
        CMD_BuildHDF5 command = new CMD_BuildHDF5();
        logger.info("instancing commandline");
        CommandLine commandLine = new CommandLine((Object)command).setCaseInsensitiveEnumValuesAllowed(true).setOptionsCaseInsensitive(true);
        logger.info("executing commandline");
        int exitCode = commandLine.execute(args);
        logger.info("exiting main");
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        MapperConfig config = MapperConfig.file(this.layoutPath);
        for (MapperConfig.RemapConfig rmapper : config.getMappers()) {
            System.err.println("running premapping phase " + rmapper.name());
            Supplier<String> input = JJQSupplier.path(rmapper.file());
            String expr = rmapper.expr();
            BufferOutput output = new BufferOutput(5000000);
            try (JJQInvoker invoker = new JJQInvoker(input, expr, output);){
                invoker.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try (KnnDataWriter kwriter = new KnnDataWriter(this.hdfOutPath);){
            System.err.println("writing training stream...");
            kwriter.writeTrainingStream(JsonLoader.readTrainingStream(config));
            System.err.println("writing test stream...");
            kwriter.writeTestStream(JsonLoader.readTestStream(config));
            if (config.getFiltersExpr().isPresent()) {
                System.err.println("writing filters stream...");
                kwriter.writeFiltersStream(JsonLoader.readFiltersStream(config));
            }
            System.err.println("writing neighbors stream...");
            kwriter.writeNeighborsStream(JsonLoader.readNeighborsStream(config));
            System.err.println("writing distances stream...");
            kwriter.writeDistancesStream(JsonLoader.readDistancesStream(config));
            System.err.println("writing metadata...");
            kwriter.writeMetadata(config);
        }
        return 0;
    }
}

