/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.buildhdf5;

import io.jhdf.HdfFile;
import io.jhdf.WritableHdfFile;
import io.nosqlbench.nbvectors.buildhdf5.MapperConfig;
import io.nosqlbench.nbvectors.buildhdf5.predicates.types.PNode;
import io.nosqlbench.nbvectors.verifyknn.datatypes.LongIndexedFloatVector;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;

public class KnnDataWriter
implements AutoCloseable {
    private final Path hdfOutPath;
    private final WritableHdfFile writable;

    public KnnDataWriter(Path hdfOutPath) {
        this.hdfOutPath = hdfOutPath;
        this.writable = HdfFile.write((Path)hdfOutPath);
    }

    public void writeTrainingStream(Iterator<LongIndexedFloatVector> iterator) {
        ArrayList vectors = new ArrayList();
        iterator.forEachRemaining(vectors::add);
        float[][] ary = new float[vectors.size()][((LongIndexedFloatVector)vectors.getFirst()).vector().length];
        for (LongIndexedFloatVector vector : vectors) {
            ary[(int)vector.index()] = vector.vector();
        }
        this.writable.putDataset("train", (Object)ary);
        this.writable.putAttribute("train_vectors", (Object)ary.length);
        this.writable.putAttribute("dimensions", (Object)ary[0].length);
    }

    public void writeTestStream(Iterator<LongIndexedFloatVector> iterator) {
        ArrayList vectors = new ArrayList();
        iterator.forEachRemaining(vectors::add);
        float[][] ary = new float[vectors.size()][((LongIndexedFloatVector)vectors.getFirst()).vector().length];
        for (LongIndexedFloatVector vector : vectors) {
            ary[(int)vector.index()] = vector.vector();
        }
        this.writable.putDataset("test", (Object)ary);
        this.writable.putAttribute("test_vectors", (Object)ary.length);
    }

    public void writeNeighborsStream(Iterator<long[]> iterator) {
        ArrayList vectors = new ArrayList();
        iterator.forEachRemaining(vectors::add);
        long[][] ary = new long[vectors.size()][((long[])vectors.getFirst()).length];
        for (int i = 0; i < ary.length; ++i) {
            ary[i] = (long[])vectors.get(i);
        }
        this.writable.putDataset("neighbors", (Object)ary);
        this.writable.putAttribute("neighbors", (Object)ary[0].length);
    }

    public void writeDistancesStream(Iterator<float[]> iterator) {
        ArrayList distances = new ArrayList();
        iterator.forEachRemaining(distances::add);
        float[][] ary = new float[distances.size()][((float[])distances.getFirst()).length];
        for (int i = 0; i < ary.length; ++i) {
            ary[i] = (float[])distances.get(i);
        }
        this.writable.putDataset("distances", (Object)ary);
    }

    @Override
    public void close() throws Exception {
        this.writable.close();
    }

    public void writeFiltersStream(Iterator<PNode<?>> nodeIterator) {
        ArrayList<byte[]> predicateEncodings = new ArrayList<byte[]>();
        ByteBuffer workingBuffer = ByteBuffer.allocate(5000000);
        int maxlen = 0;
        int minlen = Integer.MAX_VALUE;
        while (nodeIterator.hasNext()) {
            PNode<?> node = nodeIterator.next();
            workingBuffer.clear();
            node.encode(workingBuffer);
            workingBuffer.flip();
            byte[] bytes = new byte[workingBuffer.remaining()];
            workingBuffer.get(bytes);
            predicateEncodings.add(bytes);
            maxlen = Math.max(maxlen, bytes.length);
            minlen = Math.min(minlen, bytes.length);
        }
        byte[][] encoded = new byte[predicateEncodings.size()][maxlen];
        for (int i = 0; i < encoded.length; ++i) {
            encoded[i] = (byte[])predicateEncodings.get(i);
        }
        this.writable.putDataset("filters", (Object)encoded);
    }

    public void writeMetadata(MapperConfig config) {
        this.writable.putAttribute("model", (Object)config.getModel());
        this.writable.putAttribute("distance_function", (Object)config.getDistanceFunction());
    }
}

