/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.buildhdf5;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;

public class MapperConfig {
    private final Map<String, Object> cfgmap;

    public MapperConfig(Map<String, Object> cfgmap) {
        this.cfgmap = cfgmap;
    }

    public static MapperConfig file(Path layoutPath) {
        BufferedReader reader = null;
        Object cfgData = null;
        LoadSettings loadSettings = LoadSettings.builder().build();
        Load yaml = new Load(loadSettings);
        try {
            reader = Files.newBufferedReader(layoutPath, StandardCharsets.UTF_8);
            Map config = (Map)yaml.loadFromReader((Reader)reader);
            return new MapperConfig(config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTrainingExpr() {
        return (String)this.cfgmap.get("training_expr");
    }

    public Path getTrainingJsonFile() {
        return Path.of((String)this.cfgmap.get("training_file"), new String[0]);
    }

    public String getTrainingJqExpr() {
        return (String)this.cfgmap.get("training_expr");
    }

    public Path getTestJsonFile() {
        return Path.of((String)this.cfgmap.get("test_file"), new String[0]);
    }

    public String getTestJqExpr() {
        return (String)this.cfgmap.get("test_expr");
    }

    public Path getNeighborhoodJsonFile() {
        return Path.of((String)this.cfgmap.get("neighborhood_file"), new String[0]);
    }

    public String getNeighborhoodTestExpr() {
        return (String)this.cfgmap.get("neighborhood_expr");
    }

    public Path getDistancesJsonFile() {
        return Path.of((String)this.cfgmap.get("distances_file"), new String[0]);
    }

    public String getDistancesExpr() {
        return (String)this.cfgmap.get("distances_expr");
    }

    public Optional<Path> getFiltersFile() {
        return Optional.ofNullable((String)this.cfgmap.get("filters_file")).map(x$0 -> Path.of(x$0, new String[0]));
    }

    public String getModel() {
        return this.cfgmap.getOrDefault("model", "random").toString();
    }

    public String getDistanceFunction() {
        return this.cfgmap.getOrDefault("distance_function", "cosine").toString();
    }

    public Optional<String> getFiltersExpr() {
        return Optional.ofNullable((String)this.cfgmap.get("filters_expr"));
    }

    public List<RemapConfig> getMappers() {
        ArrayList<RemapConfig> mapperConfigs = new ArrayList<RemapConfig>();
        Map remaps = (Map)this.cfgmap.get("remappers");
        remaps = remaps == null ? Map.of() : remaps;
        remaps.forEach((k, v) -> mapperConfigs.add(new RemapConfig((String)k, (Map<String, String>)v)));
        return mapperConfigs;
    }

    public record RemapConfig(String name, Path file, String expr) {
        public RemapConfig(String name, Map<String, String> props) {
            this(name, Path.of(props.get("input_file"), new String[0]), props.get("expression"));
        }
    }
}

