/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.buildhdf5.predicates.repr;

import io.nosqlbench.nbvectors.buildhdf5.predicates.types.ConjugateNode;
import io.nosqlbench.nbvectors.buildhdf5.predicates.types.NodeRepresenter;
import io.nosqlbench.nbvectors.buildhdf5.predicates.types.PNode;
import io.nosqlbench.nbvectors.buildhdf5.predicates.types.PredicateNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class CqlNodeRenderer
implements NodeRepresenter {
    @Override
    public String apply(PNode<?> node) {
        PNode<?> pNode = node;
        Objects.requireNonNull(pNode);
        PNode<?> pNode2 = pNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConjugateNode.class, PredicateNode.class}, pNode2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ConjugateNode n = (ConjugateNode)pNode2;
                yield this.reprConjugate(n);
            }
            case 1 -> {
                PredicateNode p = (PredicateNode)pNode2;
                yield this.reprPredicate(p);
            }
        };
    }

    private String reprPredicate(PredicateNode p) {
        StringBuilder sb = new StringBuilder();
        sb.append("F").append(p.field());
        if (this.isChar(p.op().symbol())) {
            sb.append(" ");
        }
        sb.append(p.op().symbol());
        if (p.v().length > 1) {
            sb.append("(");
            String delim = "";
            for (long v : p.v()) {
                sb.append(delim);
                sb.append(v);
                delim = ",";
            }
            sb.append(")");
        } else {
            sb.append(p.v()[0]);
        }
        return sb.toString();
    }

    private boolean isChar(String symbol) {
        char c = symbol.charAt(0);
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private String reprConjugate(ConjugateNode n) {
        switch (n.type()) {
            default: {
                throw new MatchException(null, null);
            }
            case AND: 
            case OR: {
                break;
            }
            case PRED: {
                throw new RuntimeException("impossible unless broken code");
            }
        }
        return this.concatenate(n.type().name(), n.values());
    }

    private String concatenate(String name, PNode<?>[] values) {
        StringBuilder sb = new StringBuilder();
        for (PNode<?> value : values) {
            String nodeRep = this.apply(value);
            if (!sb.isEmpty()) {
                sb.append(" ").append(name).append(" ");
            }
            sb.append(nodeRep);
        }
        return sb.toString();
    }
}

