/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.buildhdf5.predicates.types;

import io.nosqlbench.nbvectors.buildhdf5.predicates.types.BBWriter;
import io.nosqlbench.nbvectors.buildhdf5.predicates.types.ConjugateType;
import io.nosqlbench.nbvectors.buildhdf5.predicates.types.PNode;
import java.nio.ByteBuffer;
import java.util.Arrays;

public record ConjugateNode(ConjugateType type, PNode<?>[] values) implements BBWriter<ConjugateNode>,
PNode<ConjugateNode>
{
    public ConjugateNode(ByteBuffer b) {
        this(ConjugateType.values()[b.get()], ConjugateNode.readValues(b));
    }

    private static PNode<?>[] readValues(ByteBuffer b) {
        byte count = b.get();
        PNode[] elements = new PNode[count];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = PNode.fromBuffer(b);
        }
        return elements;
    }

    @Override
    public ByteBuffer encode(ByteBuffer out) {
        out.put((byte)this.type.ordinal()).put((byte)this.values.length);
        for (PNode<?> element : this.values) {
            element.encode(out);
        }
        return out;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ConjugateNode{");
        sb.append("type=").append((Object)this.type);
        sb.append(", v=").append(this.values == null ? "null" : Arrays.asList(this.values).toString());
        sb.append('}');
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Object[] type1;
        Object[] objectArray;
        if (!(o instanceof ConjugateNode)) return false;
        ConjugateNode conjugateNode = (ConjugateNode)o;
        try {
            type1 = objectArray = conjugateNode.type();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object[] values1 = objectArray = conjugateNode.values();
        if (!Arrays.equals(this.values, values1)) return false;
        if (this.type != type1) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

