/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.buildhdf5.predicates.types;

import io.nosqlbench.nbvectors.buildhdf5.predicates.types.BBWriter;
import io.nosqlbench.nbvectors.buildhdf5.predicates.types.ConjugateType;
import io.nosqlbench.nbvectors.buildhdf5.predicates.types.OpType;
import io.nosqlbench.nbvectors.buildhdf5.predicates.types.PNode;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public record PredicateNode(int field, OpType op, long[] v) implements BBWriter<PredicateNode>,
PNode<PredicateNode>
{
    public PredicateNode(byte type, int field, OpType op, long ... v) {
        this(field, op, v);
    }

    public PredicateNode(ByteBuffer b) {
        this(b.get(), b.get(), OpType.values()[b.get()], PredicateNode.readValues(b));
    }

    private static long[] readValues(ByteBuffer b) {
        short len = b.getShort();
        long[] values = new long[len];
        for (int i = 0; i < values.length; ++i) {
            values[i] = b.getLong();
        }
        return values;
    }

    @Override
    public ByteBuffer encode(ByteBuffer out) {
        out.put((byte)ConjugateType.PRED.ordinal());
        out.put((byte)this.field).put((byte)this.op.ordinal());
        out.putShort((short)this.v.length);
        for (long l : this.v) {
            out.putLong(l);
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Object object;
        int fieldOffset;
        if (!(o instanceof PredicateNode)) return false;
        PredicateNode predicateNode = (PredicateNode)o;
        try {
            int n;
            int n2 = n = predicateNode.field();
            if (!true) return false;
            fieldOffset = n;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        OpType op1 = object = predicateNode.op();
        Object v1 = object = (Object)predicateNode.v();
        if (this.field != fieldOffset) return false;
        if (!Arrays.equals(this.v, (long[])v1)) return false;
        if (this.op != op1) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.field;
        result = 31 * result + Objects.hashCode((Object)this.op);
        result = 31 * result + Arrays.hashCode(this.v);
        return result;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("PredicateNode{");
        sb.append("field=").append(this.field);
        sb.append(", op=").append((Object)this.op);
        sb.append(", v=");
        if (this.v == null) {
            sb.append("null");
        } else {
            sb.append('[');
            for (int i = 0; i < this.v.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.v[i]);
            }
            sb.append(']');
        }
        sb.append('}');
        return sb.toString();
    }
}

