/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq;

import io.nosqlbench.nbvectors.buildhdf5.JJQSupplier;
import io.nosqlbench.nbvectors.jjq.Filemode;
import io.nosqlbench.nbvectors.jjq.evaluator.JJQInvoker;
import io.nosqlbench.nbvectors.jjq.outputs.JsonlFileOutput;
import io.nosqlbench.nbvectors.jjq.outputs.NullOutput;
import io.nosqlbench.nbvectors.jjq.outputs.PrettyConsoleOutput;
import io.nosqlbench.nbvectors.verifyknn.logging.CustomConfigurationFactory;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.thisptr.jackson.jq.Output;
import picocli.CommandLine;

@CommandLine.Command(name="jjq")
public class CMD_jjq
implements Callable<Integer> {
    @CommandLine.Option(names={"-i", "--in"}, required=true)
    private Path inFile;
    @CommandLine.Option(names={"-o", "--out"}, description={"The output path for processed JSON, 'null' means discard"}, defaultValue="stdout")
    private String outPath;
    @CommandLine.Parameters(defaultValue=".", description={"The jq expression to apply"})
    private String jq;
    @CommandLine.Option(names={"-t", "--threads"}, required=false, defaultValue="0")
    private int threads;
    @CommandLine.Option(names={"-p", "--parts"}, required=false, defaultValue="0")
    private int parts;
    @CommandLine.Option(names={"-d", "--diag"}, required=false, defaultValue="false", description={"A debugging mode that provides a simpler execution path, more data, and cleaner stack traces."})
    private boolean diagnose;
    @CommandLine.Option(names={"-m", "--filemode"}, defaultValue="checkpoint", description={"Valid values: ${COMPLETION-CANDIDATES}"})
    private Filemode filemode;
    @CommandLine.Option(names={"--skipdone"}, required=false, description={"If this file exists, silently skip invocation of this command"})
    private Path skipFile;

    public static void main(String[] args) {
        System.setProperty("slf4j.internal.verbosity", "ERROR");
        System.setProperty("log4j.configurationFactory", CustomConfigurationFactory.class.getCanonicalName());
        CMD_jjq command = new CMD_jjq();
        CommandLine commandLine = new CommandLine((Object)command).setCaseInsensitiveEnumValuesAllowed(true).setOptionsCaseInsensitive(true);
        int exitCode = commandLine.execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        if (this.skipFile != null && Filemode.checkpoint.isSkip(this.skipFile)) {
            System.err.println("skipping command, since '" + String.valueOf(this.skipFile) + "' is already present");
            return 0;
        }
        Object output = null;
        output = this.outPath == null || this.outPath.equals("stdout") ? new PrettyConsoleOutput() : (this.outPath.equalsIgnoreCase("null") ? new NullOutput() : new JsonlFileOutput(Path.of(this.outPath, new String[0])));
        Supplier<String> input = JJQSupplier.path(this.inFile);
        try (JJQInvoker invoker = new JJQInvoker(input, this.jq, (Output)output);){
            invoker.run();
        }
        return 0;
    }
}

