/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.bulkio;

import io.nosqlbench.nbvectors.jjq.bulkio.DiagToString;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class BytebufChunker
implements Iterable<CharBuffer> {
    private final ByteBuffer buf;
    private final int chunkSize;
    private final String desc;

    public BytebufChunker(String desc, ByteBuffer buf, int chunkSize) {
        this.desc = desc;
        this.buf = buf;
        this.chunkSize = chunkSize;
    }

    @Override
    public Iterator<CharBuffer> iterator() {
        return new CBIterator(this.desc, this.buf, this.chunkSize);
    }

    public static class CBIterator
    implements Iterator<CharBuffer>,
    DiagToString {
        private final ByteBuffer buf;
        private final int chunkSize;
        private final String desc;

        public CBIterator(String desc, ByteBuffer buffer, int chunkSize) {
            this.desc = desc;
            this.buf = buffer;
            this.chunkSize = chunkSize;
        }

        @Override
        public synchronized boolean hasNext() {
            return this.buf.remaining() > 0;
        }

        @Override
        public synchronized CharBuffer next() {
            int was = 0;
            int at = 0;
            try {
                was = at = Math.min(this.buf.position() + this.chunkSize, this.buf.limit());
                while (at < this.buf.limit() && this.buf.get(at) != 10) {
                    ++at;
                }
                if (at < this.buf.limit()) {
                    ++at;
                }
                int len = at - this.buf.position();
                ByteBuffer slice = this.buf.slice(this.buf.position(), len);
                this.buf.position(at);
                return StandardCharsets.UTF_8.decode(slice);
            }
            catch (Exception e) {
                System.err.println("chunksize:" + this.chunkSize + "; was:" + was + "; at:" + at + "; buf=" + String.valueOf(this.buf));
                throw new RuntimeException(e);
            }
        }

        @Override
        public String toDiagString() {
            return "desc:" + this.desc + ", position:" + this.buf.position();
        }
    }
}

