/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.bulkio;

import java.nio.CharBuffer;
import java.util.Iterator;

public class CharbufChunker
implements Iterable<CharBuffer> {
    private final CharBuffer buf;
    private final int chunkSize;

    public CharbufChunker(CharBuffer buf, int chunkSize) {
        this.buf = buf;
        this.chunkSize = chunkSize;
    }

    @Override
    public Iterator<CharBuffer> iterator() {
        return new CBIterator(this.buf, this.chunkSize);
    }

    public static class CBIterator
    implements Iterator<CharBuffer> {
        private final CharBuffer buf;
        private final int chunkSize;

        public CBIterator(CharBuffer buffer, int chunkSize) {
            this.buf = buffer;
            this.chunkSize = chunkSize;
        }

        @Override
        public synchronized boolean hasNext() {
            return this.buf.position() < this.buf.limit();
        }

        @Override
        public synchronized CharBuffer next() {
            int at = Math.min(this.chunkSize, this.buf.remaining() - 1);
            char c = this.buf.charAt(at);
            while (c != '\n' && at < this.buf.remaining()) {
                c = this.buf.charAt(at++);
            }
            CharBuffer slice = this.buf.slice(this.buf.position(), at);
            this.buf.position(this.buf.position() + at);
            return slice;
        }
    }
}

