/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.bulkio;

import io.nosqlbench.nbvectors.jjq.bulkio.BytebufChunker;
import io.nosqlbench.nbvectors.jjq.bulkio.ConcurrentSupplier;
import io.nosqlbench.nbvectors.jjq.bulkio.ConvertingIterable;
import io.nosqlbench.nbvectors.jjq.bulkio.FilePartitions;
import io.nosqlbench.nbvectors.jjq.bulkio.FlatteningIterable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;

public record FilePartition(Path path, long start, long end, String id) {
    public static FilePartition of(String path) {
        return FilePartition.of(Path.of(path, new String[0]));
    }

    public static FilePartition of(Path path) {
        try {
            return new FilePartition(path, 0L, Files.size(path), "0");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FilePartitions partition(int partitions) {
        return this.partition(partitions, 0x100000);
    }

    public FilePartitions partition(int minPartitions, int minSize) {
        FilePartitions extents = new FilePartitions();
        long len = this.end - this.start;
        if (len <= (long)minSize) {
            extents.add(this);
        } else {
            long partitions = Math.max((long)minPartitions, Math.max(1L, len / 2000000000L + 1L));
            long psize = len / partitions;
            try {
                FileChannel channel = FileChannel.open(this.path, new OpenOption[0]);
                ByteBuffer buf = ByteBuffer.allocate(0x1000000);
                long pstart = this.start;
                for (long part = 0L; part < partitions; ++part) {
                    int bytes;
                    buf.clear();
                    long pend = Math.min(pstart + psize, channel.size());
                    channel.position(pend);
                    if (channel.position() < channel.size() && (bytes = channel.read(buf)) >= 0) {
                        buf.flip();
                        int i = 0;
                        for (i = 0; i < buf.limit(); ++i) {
                            if (buf.get(i) != 10) continue;
                            pend = channel.position() - (long)buf.limit() + (long)i;
                            break;
                        }
                        if (buf.get(i) != 10) {
                            throw new RuntimeException("oops again");
                        }
                    }
                    extents.add(new FilePartition(this.path, pstart, pend, this.id + String.format(":%03d", part)));
                    pstart = pend;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return extents;
    }

    public ByteBuffer mapFile() {
        long size = this.end - this.start;
        if (size > Integer.MAX_VALUE) {
            throw new RuntimeException("File partition is too large to read into a ByteBuffer: " + size + " bytes");
        }
        if (size == 0L) {
            throw new RuntimeException("File partition is empty");
        }
        ByteBuffer.allocate((int)size);
        try {
            FileChannel channel = FileChannel.open(this.path, new OpenOption[0]);
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, this.start, size);
            return buf;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append(":");
        sb.append(this.path).append(":");
        sb.append(this.start).append("..");
        sb.append(this.end).append("[");
        ByteBuffer bb = this.mapFile();
        sb.append(StandardCharsets.UTF_8.decode(bb.slice(0, 15)).toString().replaceAll("\n", "\\\\n"));
        sb.append("..");
        sb.append(StandardCharsets.UTF_8.decode(bb.slice(bb.limit() - 15, 15)).toString().replaceAll("\n", "\\\\n"));
        sb.append("]");
        return sb.toString();
    }

    private Iterable<String> asStringIterable() {
        ByteBuffer byteBuffer = this.mapFile();
        ConvertingIterable<CharBuffer, String> ci = new ConvertingIterable<CharBuffer, String>(new BytebufChunker(this.toString(), byteBuffer, 50000), Object::toString);
        FlatteningIterable linesIter = new FlatteningIterable(ci, s -> Arrays.asList(s.split("\n")));
        return linesIter;
    }

    public ConcurrentSupplier<String> asConcurrentSupplier() {
        return new ConcurrentSupplier<String>(this.asStringIterable(), Runtime.getRuntime().availableProcessors() * 2, e -> {
            throw e;
        });
    }
}

