/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.bulkio;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;

public class LineChunker
implements Iterable<CharBuffer> {
    private final FileChannel channel;
    private final int maxBufSize;

    public LineChunker(Path path, long startAt, int linesPerChunk) {
        try {
            String line;
            int sumcount;
            BufferedReader br = Files.newBufferedReader(path);
            long sumlen = 0L;
            for (sumcount = 0; (line = br.readLine()) != null && sumcount < 32; ++sumcount) {
                sumlen += (long)line.length();
            }
            this.maxBufSize = (int)(sumlen / (long)sumcount) * linesPerChunk;
            this.channel = FileChannel.open(path, new OpenOption[0]);
            this.channel.position(startAt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<CharBuffer> iterator() {
        return new LineChunkIterator();
    }

    private class LineChunkIterator
    implements Iterator<CharBuffer> {
        private LineChunkIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                return LineChunker.this.channel.position() < LineChunker.this.channel.size();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public CharBuffer next() {
            ByteBuffer buffer = ByteBuffer.allocate(LineChunker.this.maxBufSize);
            try {
                int readSize = LineChunker.this.channel.read(buffer);
                if (readSize == 0) {
                    return null;
                }
                if (LineChunker.this.channel.position() != LineChunker.this.channel.size()) {
                    for (int i = buffer.position() - 1; i > 0; --i) {
                        byte c = buffer.get(i);
                        if (c != 10) continue;
                        int extra = buffer.position() - (i + 1);
                        buffer.limit(i);
                        LineChunker.this.channel.position(LineChunker.this.channel.position() - (long)extra);
                        break;
                    }
                }
                buffer.flip();
                return StandardCharsets.UTF_8.decode(buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

