/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.bulkio;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LinePartitioner
implements Iterable<Extent> {
    private final List<Extent> extents = new ArrayList<Extent>();

    public LinePartitioner(Path path, long startIncl, long endExcl, int partitions) {
        try {
            FileChannel channel = FileChannel.open(path, new OpenOption[0]);
            long startAt = startIncl;
            long endAt = Math.min(endExcl, channel.size());
            if (endExcl == 0L) {
                endExcl = channel.size();
            }
            this.extents.addAll(new Extent(startAt, endAt).partition(channel, partitions));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<Extent> iterator() {
        return this.extents.iterator();
    }

    public record Extent(long start, long end) {
        public List<Extent> partition(FileChannel br, int partitions) {
            return null;
        }
    }
}

